#!/bin/bash
export datasets="Cora CiteSeer PubMed wikics cs physics"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=0

for missing_rate in $missing_rates
do
for embedder_lp in $embedder_lp_list
do
python main.py --dataset Cora --lp_alpha 0.99 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset Cora --lp_alpha 0.99 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset CiteSeer --lp_alpha 0.999 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset CiteSeer --lp_alpha 0.999 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset PubMed --lp_alpha 0.999 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset PubMed --lp_alpha 0.999 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type structural --gpu ${gpu}
done
done

for missing_rate in $missing_rates
do
for embedder_lp in $embedder_lp_list
do
python main.py --dataset wikics --lp_alpha 0.9 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --lp_alpha 0.9 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset cs --lp_alpha 0.99 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset cs --lp_alpha 0.99 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset physics --lp_alpha 0.999 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset physics --lp_alpha 0.999 --missing_rate ${missing_rate} --embedder ${embedder_lp} --n_runs 10 --missing_type structural --gpu ${gpu}
done
done