#!/bin/bash
export datasets_="Cora CiteSeer PubMed wikics cs physics"
export datasets="Cora CiteSeer PubMed"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export _lambda_list="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export _missing_rates="0.0 1.0"
export lambda_list="0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=2

for missing_rate in $missing_rates
do
python main.py --dataset wikics --lp_alpha 0.9 --lamb 0.6 --missing_rate ${missing_rate} --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset wikics --lp_alpha 0.9 --lamb 0.6 --missing_rate ${missing_rate} --embedder GOODIE --n_runs 10 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset cs --lp_alpha 0.99 --lamb 0.7 --missing_rate ${missing_rate} --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset cs --lp_alpha 0.99 --lamb 0.7 --missing_rate ${missing_rate} --embedder GOODIE --n_runs 10 --missing_type structural --gpu ${gpu}
done