#!/bin/bash
export datasets="wikics cs"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_1="0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_2="0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=1

for missing_rate in $missing_rates_1
do
python main.py --dataset OGBN-Arxiv --missing_rate ${missing_rate} --embedder GNN --filling_method neighborhood_mean --n_runs 10 --missing_type uniform --gpu ${gpu}
done

python main.py --dataset OGBN-Arxiv --missing_rate 0.6 --embedder Node2Vec_x --n_runs 10 --missing_type uniform --gpu ${gpu}

for missing_rate in $missing_rates_1
do
python main.py --dataset OGBN-Arxiv --missing_rate ${missing_rate} --embedder Node2Vec_x --n_runs 10 --missing_type uniform --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset OGBN-Arxiv --missing_rate ${missing_rate} --embedder Node2Vec_x --n_runs 10 --missing_type structural --gpu ${gpu}
done

