from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from tqdm import trange
from layers import GCN, GAT, SAGE, SGC, MLP
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj
from torch_geometric.nn.inits import reset, glorot, zeros
from sklearn.decomposition import PCA
from filling_strategies import filling

class PPL():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)
            # self.adj = self.adj.to(self.args.device)

            # Obtain Pseudo Labels
            lp_model = LabelPropagation(num_layers=50, alpha=self.args.lp_alpha)
            lp_output = lp_model(y=self.labels, edge_index=self.edge_index, mask=self.train_mask)
            self.pseudo_labels = lp_output.argmax(1)
            
            # one_hot = torch.FloatTensor(torch.nn.functional.one_hot(self.pseudo_labels.cpu()) + 0.0)
            # prediction_matrix = torch.mm(one_hot, one_hot.T)

            # adj_ = self.adj * prediction_matrix
            # tmp_edge_index = adj_.to_sparse().indices().to(self.args.device)
            tmp_edge_index = self.edge_index
            filled_features = filling(self.args.filling_method, tmp_edge_index, self.x, self.missing_feature_mask, self.args.hop, self.args.replace, self.args.num_iterations, self.args.normalize_feature)
            self.x = torch.where(self.missing_feature_mask, self.x, filled_features)

            # Leveraging partial labels
            self.edge_weight = None
            edge_weight = None
            self.x = torch.nan_to_num(self.x, 0)

            # # DADX -> PCA
            # pca = PCA(n_components=self.args.n_hid)
            # self.x = torch.FloatTensor(pca.fit_transform(self.x.cpu())).to(self.args.device)
            # self.args.n_feat = self.args.n_hid
            
            # pca_embed = self.x
            # for i in range(40):
            #     tmp_edge_index, tmp_DAD = utils.get_symmetrically_normalized_adjacency(self.edge_index, self.x.shape[0])
            #     tmp_adj = to_dense_adj(tmp_edge_index, edge_attr=tmp_DAD)[0]
            #     self.x = torch.mm(tmp_adj, self.x)            
            
            # sim = F.normalize(self.x) @ F.normalize(self.x.T)
            # # sim = F.normalize(self.x @ self.x.T)
            # edge_weight = self.adj * sim
            # edge_weight = F.normalize(self.adj * sim)
            # edge_weight = F.normalize(self.adj) + F.normalize(self.adj * sim)
            # self.edge_index, self.edge_weight = edge_weight.to_sparse().indices(), edge_weight.to_sparse().values()

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)

            acc_vals = []
            test_results = []
            best_metric = 0

            # pca_x = self.x

            for epoch in range(0, self.args.epochs):
                model.train()
                optimizer.zero_grad()

                loss = model(self.x, lp_output, self.edge_index, self.edge_weight, self.labels, self.train_mask)
                # loss = model(lp_output, self.edge_index, self.edge_weight, pca_x, self.pseudo_labels, torch.where(self.train_mask, True, True))

                # loss = model(lp_output, self.edge_index, self.pseudo_labels, torch.where(self.train_mask, True, True))

                loss.backward()
                optimizer.step()

                # Valid
                model.eval()

                fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)
                        
                fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)

                output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64
                
                # output = model.classifier2(output_, self.edge_index, self.edge_weight, transpose=True)
                output = model.classifier3(output_, self.edge_index, self.edge_weight)
                lp_output = output.detach()
                

                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid', evaluator=self.evaluator)

                acc_vals.append(acc_val)

                if best_metric <= acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]
                    best_value_0 = torch.mean(values[:,0]).item()
                    best_value_1 = torch.mean(values[:,1]).item()
                    # best_model = deepcopy(model)

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    st = "[seed {}][{}-{}][{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
                        # model = best_model
                        # fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                        # lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)
                                
                        # fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                        # lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                        # values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)

                        # output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64
                    
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break
            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info(f'----------- missing rate: {self.args.missing_rate} -----------')
        logger.info(f'----------- lp alpha: {self.args.lp_alpha} -----------')
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(f1), np.std(f1)))
        logger.info('Attn Score 0:', best_value_0)
        logger.info('Attn Score 1:', best_value_1)
        logger.info(self.args)
        logger.info(f'=================================')
        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            classifier1 = GCN(1, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False)
            classifier2 = GCN(1, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=True)
            classifier3 = GCN(1, args.n_hid, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False, classifier=True)
            # classifier3 = MLP(num_features=args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm, classifier=True)

            # classifier3 = MLP(num_features=args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm)
            # classifier2 = MLP(num_features=2 * args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm)
            # classifier = GCN(args.n_layer, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False)
        elif args.gnn == "SAGE":
            classifier = SAGE(args.n_layer, args.n_feat, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        self.classifier1 = classifier1
        self.classifier2 = classifier2
        self.classifier3 = classifier3
        self.triplet_loss = torch.nn.TripletMarginLoss(margin=1.0, p=2)
        self.leakyrelu = nn.LeakyReLU(args.leaky_alpha)
        self.attention = nn.Parameter(torch.empty(size=(args.n_hid, 1)))
        glorot(self.attention)
        #self.q = model.Attention(args.nclass, 1)

    def forward(self, x, lp_embed, edge_index, edge_weight, labels, idx_train, triplet_mask=None):
        _fp_embed = self.classifier1(x, edge_index, edge_weight, embed=True)
        _lp_embed = self.classifier2(lp_embed, edge_index, edge_weight, embed=True)

        # loss_metric = self.metric_learning(lp_embed, triplet_mask)
        # output = torch.mm(F.normalize(embed)+F.normalize(pca_x), self.classifier.conv1[0].lin.weight)
        
        # fp_ = self.leakyrelu(self.attention(fp_embed))
        # lp_ = self.leakyrelu(self.attention(lp_embed))

        # fp_ = self.leakyrelu(fp_embed * self.attention.squeeze(1))
        # lp_ = self.leakyrelu(lp_embed * self.attention.squeeze(1))

        fp_ = self.leakyrelu(torch.mm(_fp_embed, self.attention))
        lp_ = self.leakyrelu(torch.mm(_lp_embed, self.attention))
        values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
        output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64
        # loss_metric = self.metric_learning(output_, lp_embed, triplet_mask)

        # output_ = ((1-self.args.missing_rate) * fp_embed) + (self.args.missing_rate * lp_embed) # 86 x 64
        # output_ = ((1-self.args.missing_rate) * lp_embed) + (self.args.missing_rate * fp_embed) # 86 x 64
        # loss_metric = self.metric_learning(output_, lp_embed, triplet_mask)

        if self.args.coef_loss:
            fp_coef_loss = torch.norm((values[:,0]) - (1-self.args.missing_rate), 2)
            lp_coef_loss = torch.norm((values[:,1]) - self.args.missing_rate, 2)

            # fp_coef_loss = torch.norm((values[:,0]).mean() - (1-self.args.missing_rate), 2)
            # lp_coef_loss = torch.norm((values[:,1]).mean() - self.args.missing_rate, 2)

            coef_loss = fp_coef_loss + lp_coef_loss

        #output = self.classifier2(output_, edge_index, edge_weight, transpose=True)
        output = self.classifier3(output_, edge_index, edge_weight)
        
        if 'OGBN' in self.args.dataset:
            labels = labels.squeeze(1)
        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])

        # loss = (1-self.args.missing_rate) * loss_metric + self.args.missing_rate * loss_nodeclassification
        # loss = (1-self.args.missing_rate) * loss_nodeclassification + self.args.missing_rate * loss_metric
        if self.args.coef_loss:
            loss = loss_nodeclassification + self.args.alpha * coef_loss
        else:
            # loss = loss_nodeclassification + self.args.alpha * loss_metric
            # loss = loss_nodeclassification + self.args.alpha * loss_metric
            # loss = loss_nodeclassification + loss_metric
            loss = loss_nodeclassification
        
        return loss

    def metric_learning(self, embed, lp_output, triplet_mask):
        loss_metric = 0
        for i in range(len(triplet_mask)):
            anchor = embed[triplet_mask[i][0]]
            # positive = embed[triplet_mask[i][1]]
            # negative = embed[triplet_mask[i][2]]

            ## pos: shuffling neg: shuffling
            if self.args.metric == 'shu-shu':
                _positive = embed[triplet_mask[i][1]]
                positive = _positive[torch.randperm(_positive.size()[0])]

                _negative = embed[triplet_mask[i][2]]
                negative = _negative[torch.randperm(_negative.size()[0])]
            
            ## pos: re-ordering neg: shuffling
            elif self.args.metric == 're-shu' or self.args.metric == 'gt':
                _positive = embed[triplet_mask[i][1]]
                positive_val = lp_output[triplet_mask[i][1]].max(1).values
                positive = _positive[torch.sort(positive_val, descending=True).indices]
                
                _negative = embed[triplet_mask[i][2]]
                negative = _negative[torch.randperm(_negative.size()[0])]

            ## pos: re-ordering neg: re-ordering (worst)
            elif self.args.metric == 're-re':
                _positive = embed[triplet_mask[i][1]]
                positive_val = lp_output[triplet_mask[i][1]].max(1).values
                positive = _positive[torch.sort(positive_val, descending=True).indices]
                
                _negative = embed[triplet_mask[i][2]]
                negative_val = lp_output[triplet_mask[i][2]].max(1).values
                negative = _negative[torch.sort(negative_val, descending=False).indices]

            # num_sample = min(num_anchor, len(positive), len(negative))
            num_sample = min(positive.shape[0], negative.shape[0])
            num_anchor = len(anchor)
            num_batch = int(num_sample/num_anchor)
            tmp_loss = 0
            for i in range(num_batch):
                _loss = self.triplet_loss(anchor, positive[(i)*num_anchor:(i+1)*num_anchor], negative[(i)*num_anchor:(i+1)*num_anchor])
                tmp_loss += _loss
            
            # loss_metric += tmp_loss
            loss_metric += (tmp_loss / num_batch)

        return loss_metric / len(triplet_mask)

            # 66.20+8.57 (coef False)
            # 59.90+8.93 (coef_loss True)
            # 66.73+6.79(coef_loss reverse)
