from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from tqdm import trange
from layers import GCN, GAT, SAGE, SGC, MLP
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj

from sklearn.decomposition import PCA

class PPL():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)
            # self.adj = self.adj.to(self.args.device)

            # Obtain Pseudo Labels
            lp_output = torch.rand([2485,7])

            # lp_model = LabelPropagation(num_layers=50, alpha=self.args.lp_alpha)
            # lp_output = lp_model(y=self.labels, edge_index=self.edge_index, mask=self.train_mask)
            self.pseudo_labels = lp_output.argmax(1)

            # Obtain mask
            triplet_mask = None
            # triplet_mask = []
            # for i in range(self.args.n_class):
            #     anchor = (self.labels == i) * self.train_mask
            #     # positive = torch.where(anchor, False, self.pseudo_labels == i)
            #     positive = torch.where(anchor, False, self.labels == i)
            #     # negative = torch.where(self.pseudo_labels == i, False, True)
            #     negative = torch.where(self.labels == i, False, self.train_mask)

            #     triplet_mask.append([anchor, positive, negative])
            #     # label_pseudo = (data.pseudo_y == i)
            #     # label_mask_list.append([label_train, label_pseudo])
            #     # label_mask_list.append(label_pseudo)

            # Leveraging partial labels
            self.edge_weight = None
            edge_weight = None
            self.x = torch.nan_to_num(self.x, 0)

            # # DADX -> PCA
            pca = PCA(n_components=self.args.n_hid)
            self.x = torch.FloatTensor(pca.fit_transform(self.x.cpu())).to(self.args.device)
            pca_embed = self.x
            # for i in range(40):
            #     tmp_edge_index, tmp_DAD = utils.get_symmetrically_normalized_adjacency(self.edge_index, self.x.shape[0])
            #     tmp_adj = to_dense_adj(tmp_edge_index, edge_attr=tmp_DAD)[0]
            #     self.x = torch.mm(tmp_adj, self.x)            
            
            # sim = F.normalize(self.x) @ F.normalize(self.x.T)
            # # sim = F.normalize(self.x @ self.x.T)
            # edge_weight = self.adj * sim
            # edge_weight = F.normalize(self.adj * sim)
            # edge_weight = F.normalize(self.adj) + F.normalize(self.adj * sim)
            # self.edge_index, self.edge_weight = edge_weight.to_sparse().indices(), edge_weight.to_sparse().values()
            

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)

            acc_vals = []
            test_results = []
            best_metric = 0

            # pca_x = self.x

            for epoch in range(0, self.args.epochs):
                model.train()
                optimizer.zero_grad()

                loss = model(lp_output, self.edge_index, self.edge_weight, self.labels, self.train_mask, triplet_mask, pca_embed)
                # loss = model(lp_output, self.edge_index, self.edge_weight, pca_x, self.pseudo_labels, torch.where(self.train_mask, True, True))

                # loss = model(lp_output, self.edge_index, self.pseudo_labels, torch.where(self.train_mask, True, True))

                loss.backward()
                optimizer.step()

                # Valid
                model.eval()
                output = model.classifier(lp_output, self.edge_index, self.edge_weight, edge_attr=pca_embed)
                # lp_embed = model.classifier1(lp_output, self.edge_index, self.edge_weight, embed=True)
                # embed = torch.cat((lp_embed, pca_embed), 1)
                # output = model.classifier2(embed, self.edge_index, self.edge_weight)
                # output = torch.mm(embed+pca_x, model.classifier.conv1[0].lin.weight)
                
                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid', evaluator=self.evaluator)

                acc_vals.append(acc_val)

                if best_metric <= acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    st = "[seed {}][{}-{}][{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break

            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info(f'----------- missing rate: {self.args.missing_rate} -----------')
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(f1), np.std(f1)))
        logger.info(self.args)
        logger.info(f'=================================')

        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            # classifier1 = GCN(1, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False)
            # classifier2 = GCN(1, 2 * args.n_hid, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False)
            # classifier2 = MLP(num_features=2 * args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm)
            # classifier = GCN(args.n_layer, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
            print()
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False, edge_dim=args.n_hid, transpose=True)
        elif args.gnn == "SAGE":
            classifier = SAGE(args.n_layer, args.n_feat, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        
        classifier = GAT(args.n_layer, args.n_class, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False, edge_dim=args.n_hid, transpose=True)
        # self.classifier1 = classifier1
        # self.classifier2 = classifier2
        self.classifier = classifier
        self.triplet_loss = torch.nn.TripletMarginLoss(margin=1.0, p=2)

    def forward(self, x, edge_index, edge_weight, labels, idx_train, triplet_mask=None, edge_attr=None):
        # lp_embed = self.classifier1(x, edge_index, edge_weight, embed=True)
        # loss_metric = self.metric_learning(lp_embed, triplet_mask)
        # embed = torch.cat((lp_embed, pca_embed), 1)
        output = self.classifier(x, edge_index, edge_weight, edge_attr=edge_attr)
        # output = torch.mm(F.normalize(embed)+F.normalize(pca_x), self.classifier.conv1[0].lin.weight)
        if 'OGBN' in self.args.dataset:
            labels = labels.squeeze(1)
        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])

        # loss = (1-self.args.missing_rate) * loss_metric + self.args.missing_rate * loss_nodeclassification
        # loss = (1-self.args.missing_rate) * loss_nodeclassification + self.args.missing_rate * loss_metric

        return loss_nodeclassification

    def metric_learning(self, embed, triplet_mask):
        loss_metric = 0
        for i in range(len(triplet_mask)):
            anchor = embed[triplet_mask[i][0]]
            _positive = embed[triplet_mask[i][1]]
            # positive re-ordering
            # positive_val = lp_prediction[triplet_mask[i][1]].max(1).values
            # positive = _positive[torch.sort(positive_val, descending=True).indices]
            positive = embed[triplet_mask[i][1]]
            # negative shuffling
            _negative = embed[triplet_mask[i][2]]
            negative = _negative[torch.randperm(_negative.size()[0])]

            num_sample = min(positive.shape[0], negative.shape[0])
            num_anchor = len(anchor)
            # num_sample = min(num_anchor, len(positive), len(negative))
            num_batch = int(num_sample/num_anchor)
            tmp_loss = 0
            for i in range(num_batch):
                _loss = self.triplet_loss(anchor, positive[(i)*num_anchor:(i+1)*num_anchor], negative[(i)*num_anchor:(i+1)*num_anchor])
                tmp_loss += _loss
            
            # loss_metric += tmp_loss
            loss_metric += tmp_loss / num_batch

            return loss_metric