from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from tqdm import trange
from layers import GCN, GAT, SAGE, SGC, MLP
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj
from torch_geometric.nn.inits import reset, glorot, zeros
from sklearn.decomposition import PCA
from filling_strategies import filling
import pickle

class PPL_contrastive_test():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
        # for seed in trange(5, 6):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)
            
            filled_features_fp = filling('fp', self.edge_index, self.x, self.missing_feature_mask, self.args.hop, self.args.replace, self.args.num_iterations, self.args.normalize_feature)
            self.x = torch.where(self.missing_feature_mask, self.x, filled_features_fp)

            del self.missing_feature_mask
            del filled_features_fp
            torch.cuda.empty_cache()

            # Obtain Pseudo Labels
            lp_model = LabelPropagation(num_layers=50, alpha=self.args.lp_alpha)
            lp_output = lp_model(y=self.labels, edge_index=self.edge_index, mask=self.train_mask)
            lp_prediction = torch.softmax(lp_output / 1, 1).max(1)[0]
            lp_prediction[self.train_mask] = 1.0

            lp_pred_mat_1 = lp_prediction.unsqueeze(1) @ torch.ones_like(lp_prediction).unsqueeze(1).T
            lp_pred_mat_2 = torch.ones_like(lp_prediction).unsqueeze(1) @ lp_prediction.unsqueeze(1).T

            if self.args.mat_type == 'mul':
                lp_pred_mat = lp_prediction.unsqueeze(1) @ lp_prediction.unsqueeze(1).T # Otherwise, you can try min or max !
            elif self.args.mat_type == 'max':
                lp_pred_mat_mul = lp_prediction.unsqueeze(1) @ lp_prediction.unsqueeze(1).T # Otherwise, you can try min or max !
                lp_pred_mat_max = torch.max(lp_pred_mat_1, lp_pred_mat_2)
                lp_pred_mat = torch.where(lp_pred_mat_max == 1, lp_pred_mat_mul, lp_pred_mat_max) # have to consider memory!
            elif self.args.mat_type == 'mean':
                lp_pred_mat = (lp_pred_mat_1 + lp_pred_mat_2) / 2
            elif self.args.mat_type == 'min':
                lp_pred_mat = torch.min(lp_pred_mat_1, lp_pred_mat_2)

            del lp_pred_mat_1
            del lp_pred_mat_2
            del lp_prediction
            torch.cuda.empty_cache()
            
            self.pseudo_labels = lp_output.argmax(1)

            # Leveraging partial labels
            self.edge_weight = None
            edge_weight = None
            # self.x = torch.nan_to_num(self.x, 0)

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)

            acc_vals = []
            test_results = []
            best_metric = 0

            # pca_x = self.x

            for epoch in range(0, self.args.epochs):
                model.train()
                optimizer.zero_grad()

                loss_ce, loss_con = model(self.x, lp_output, self.edge_index, self.edge_weight, self.labels, self.pseudo_labels, self.train_mask, weight_mask=lp_pred_mat)
                loss = loss_ce + self.args.lamb * loss_con

                loss.backward()
                optimizer.step()

                # Valid
                model.eval()

                fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)
                        
                fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)

                output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64

                # output = model.classifier2(output_, self.edge_index, self.edge_weight, transpose=True)
                output = model.classifier3(output_, self.edge_index, self.edge_weight)
                # lp_output = output.detach()

                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid', evaluator=self.evaluator)

                acc_vals.append(acc_val)

                if best_metric < acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]
                    a = values[:,0].mean()
                    b = values[:,1].mean()

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    st = "[seed {}][{}-{}][{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                    # print(loss_ce.item())
                    # print(loss_con.item())
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
  
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break
            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info(f'----------- missing rate: {self.args.missing_rate} -----------')
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(f1), np.std(f1)))
        logger.info(self.args)
        print(a)
        print(b)
        logger.info(f'=================================')

        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            classifier1 = GCN(1, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False)
            classifier2 = GCN(1, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=True)
            classifier3 = GCN(1, args.n_hid, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False, classifier=True)
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False)
        elif args.gnn == "SAGE":
            classifier = SAGE(args.n_layer, args.n_feat, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        self.classifier1 = classifier1
        self.classifier2 = classifier2
        self.classifier3 = classifier3
        self.triplet_loss = torch.nn.TripletMarginLoss(margin=1.0, p=2)
        self.leakyrelu = nn.LeakyReLU(args.leaky_alpha)
        self.attention = nn.Parameter(torch.empty(size=(args.n_hid, 1)))
        glorot(self.attention)
        #self.q = model.Attention(args.nclass, 1)

    def forward(self, x, lp_embed, edge_index, edge_weight, labels, pseudo_labels, idx_train, weight_mask=None):
        _fp_embed = self.classifier1(x, edge_index, edge_weight, embed=True)
        _lp_embed = self.classifier2(lp_embed, edge_index, edge_weight, embed=True)

        fp_ = self.leakyrelu(torch.mm(_fp_embed, self.attention))
        lp_ = self.leakyrelu(torch.mm(_lp_embed, self.attention))
        values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
        output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64

        # sup_con_loss = self.sup_loss(output_[idx_train].unsqueeze(1), labels[idx_train])
        # sup_con_loss = self.sup_loss(output_.unsqueeze(1), labels)
        
        sup_con_loss = self.sup_loss(output_, pseudo_labels, weight_mask=weight_mask)
        output = self.classifier3(output_, edge_index, edge_weight)

        if 'OGBN' in self.args.dataset:
            labels = labels.squeeze(1)
        
        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])
        
        # return loss_nodeclassification + loss_nce
        return loss_nodeclassification, sup_con_loss


    def sup_loss(self, features, labels=None, mask=None, contrast_mode='all', temp=0.07, base_temp=0.07, weight_mask=None):
        """Compute loss for model. If both `labels` and `mask` are None,
        it degenerates to SimCLR unsupervised loss:
        https://arxiv.org/pdf/2002.05709.pdf
        Args:
            features: hidden vector of shape [bsz, n_views, ...].
            labels: ground truth of shape [bsz].
            mask: contrastive mask of shape [bsz, bsz], mask_{i,j}=1 if sample j
                has the same class as sample i. Can be asymmetric.
        Returns:
            A loss scalar.
        """
        # if len(features.shape) < 3:
        #     raise ValueError('`features` needs to be [bsz, n_views, ...],'
        #                      'at least 3 dimensions are required')
        # if len(features.shape) > 3:
        #     features = features.view(features.shape[0], features.shape[1], -1)
        features = F.normalize(features, dim=-1)
        features = features.unsqueeze(1)

        batch_size = features.shape[0]
        if labels is not None and mask is not None:
            raise ValueError('Cannot define both `labels` and `mask`')
        elif labels is None and mask is None:
            mask = torch.eye(batch_size, dtype=torch.float32).to(self.args.device)
        elif labels is not None:
            labels = labels.contiguous().view(-1, 1)
            if labels.shape[0] != batch_size:
                raise ValueError('Num of labels does not match num of features')
            # mask = torch.eq(labels, labels.T).float().to(self.args.device)
            # torch.sparse.FloatTensor(torch.eq(labels, labels.T))
            mask = torch.eq(labels, labels.T)
            # neg_mask = torch.where(mask == 1, 0, 1)
        else:
            mask = mask.float().to(self.args.device)

        contrast_count = features.shape[1]
        # contrast_feature = torch.cat(torch.unbind(features, dim=1), dim=0)
        anchor_feature = torch.cat(torch.unbind(features, dim=1), dim=0)
        if contrast_mode == 'one':
            anchor_feature = features[:, 0]
            anchor_count = 1
        elif contrast_mode == 'all':
            # anchor_feature = contrast_feature
            anchor_count = contrast_count
        else:
            raise ValueError('Unknown mode: {}'.format(self.contrast_mode))

        # compute logits
        anchor_dot_contrast = torch.div(
            torch.matmul(anchor_feature, anchor_feature.T),
            self.args.temp)
        # for numerical stability
        logits_max, _ = torch.max(anchor_dot_contrast, dim=1, keepdim=True)
        logits = anchor_dot_contrast - logits_max.detach()

        del anchor_dot_contrast
        del logits_max
        torch.cuda.empty_cache()

        # tile mask
        # mask = mask.repeat(anchor_count, contrast_count)
        # mask-out self-contrast cases
        logits_mask = torch.scatter(
            torch.ones_like(mask),
            1,
            torch.arange(batch_size * anchor_count).view(-1, 1).to(self.args.device),
            0
        )
        mask = mask * logits_mask

        # compute log_prob
        # exp_logits = torch.exp(logits) * logits_mask

        # del logits_mask
        # torch.cuda.empty_cache()

        log_prob = logits - torch.log((torch.exp(logits) * logits_mask).sum(1, keepdim=True))

        del logits_mask
        del logits
        torch.cuda.empty_cache()

        # log_prob = torch.log(weight_mask * torch.exp(logits)) - torch.log(exp_logits.sum(1, keepdim=True))
        # log_prob = weight_mask * logits - torch.log(exp_logits.sum(1, keepdim=True))

        # compute mean of log-likelihood over positive
        mask = mask.float()
        mean_log_prob_pos = (weight_mask * mask * log_prob).sum(1) / mask.cpu().sum(1)
        # mean_log_prob_pos = (mask * log_prob).sum(1) / mask.sum(1)

        # loss
        loss = - (temp / base_temp) * mean_log_prob_pos
        loss = loss.view(anchor_count, batch_size).mean()

        return loss























    # def sup_loss_og(self, features, labels=None, mask=None):
    #     """Compute loss for model. If both `labels` and `mask` are None,
    #     it degenerates to SimCLR unsupervised loss:
    #     https://arxiv.org/pdf/2002.05709.pdf
    #     Args:
    #         features: hidden vector of shape [bsz, n_views, ...].
    #         labels: ground truth of shape [bsz].
    #         mask: contrastive mask of shape [bsz, bsz], mask_{i,j}=1 if sample j
    #             has the same class as sample i. Can be asymmetric.
    #     Returns:
    #         A loss scalar.
    #     """
    #     if len(features.shape) < 3:
    #         raise ValueError('`features` needs to be [bsz, n_views, ...],'
    #                          'at least 3 dimensions are required')
    #     if len(features.shape) > 3:
    #         features = features.view(features.shape[0], features.shape[1], -1)

    #     batch_size = features.shape[0]
    #     if labels is not None and mask is not None:
    #         raise ValueError('Cannot define both `labels` and `mask`')
    #     elif labels is None and mask is None:
    #         mask = torch.eye(batch_size, dtype=torch.float32).to(self.args.device)
    #     elif labels is not None:
    #         labels = labels.contiguous().view(-1, 1)
    #         if labels.shape[0] != batch_size:
    #             raise ValueError('Num of labels does not match num of features')
    #         mask = torch.eq(labels, labels.T).float().to(self.args.device)
    #     else:
    #         mask = mask.float().to(self.args.device)

    #     contrast_count = features.shape[1]
    #     contrast_feature = torch.cat(torch.unbind(features, dim=1), dim=0)
    #     if self.contrast_mode == 'one':
    #         anchor_feature = features[:, 0]
    #         anchor_count = 1
    #     elif self.contrast_mode == 'all':
    #         anchor_feature = contrast_feature
    #         anchor_count = contrast_count
    #     else:
    #         raise ValueError('Unknown mode: {}'.format(self.contrast_mode))

    #     # compute logits
    #     anchor_dot_contrast = torch.div(
    #         torch.matmul(anchor_feature, contrast_feature.T),
    #         self.temperature)
    #     # for numerical stability
    #     logits_max, _ = torch.max(anchor_dot_contrast, dim=1, keepdim=True)
    #     logits = anchor_dot_contrast - logits_max.detach()

    #     # tile mask
    #     mask = mask.repeat(anchor_count, contrast_count)
    #     # mask-out self-contrast cases
    #     logits_mask = torch.scatter(
    #         torch.ones_like(mask),
    #         1,
    #         torch.arange(batch_size * anchor_count).view(-1, 1).to(device),
    #         0
    #     )
    #     mask = mask * logits_mask

    #     # compute log_prob
    #     exp_logits = torch.exp(logits) * logits_mask
    #     log_prob = logits - torch.log(exp_logits.sum(1, keepdim=True))

    #     # compute mean of log-likelihood over positive
    #     mean_log_prob_pos = (mask * log_prob).sum(1) / mask.sum(1)

    #     # loss
    #     loss = - (self.temperature / self.base_temperature) * mean_log_prob_pos
    #     loss = loss.view(anchor_count, batch_size).mean()

    #     return loss