#!/bin/bash
export datasets="Cora CiteSeer PubMed Photo"
export missing_rates="0.0 0.1 0.9999 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export gpu=2

for data in $datasets
do
for lp_alpha in $lp_alpha_list
do
python main.py --dataset ${data} --missing_rate 0.0 --embedder LP --lp_alpha ${lp_alpha}  --n_runs 10 --filling_method fp --gpu ${gpu}
for missing_rate in $missing_rates
do
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --lp_alpha ${lp_alpha} --n_runs 10 --filling_method fp --gpu ${gpu}
done
done
done