#!/bin/bash
export datasets="PubMed wikics"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export gpu=0

for dataset in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder MLP --filling_method zero --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method zero --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method zero --pca True --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder PaGNN --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GCNMF --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method neighborhood_mean --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method fp --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method fp --pca True --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder Node2Vec --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder Node2Vec_GNN --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder Node2Vec_x --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder LP --n_runs 10 --missing_type structural --gpu ${gpu}
done
done