#!/bin/bash
export datasets="physics"
export missing_rates="0.0 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export gpu=2

for dataset in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --lp_alpha 0.999 --batch_size 2048 --embedder PPL_contrastive_test_2 --n_runs 3 --mat_type min --missing_type uniform --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --lp_alpha 0.999 --batch_size 4096 --embedder PPL_contrastive_test_2 --n_runs 3 --mat_type min --missing_type uniform --gpu ${gpu}
done
done