#!/bin/bash
export datasets="OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.995 0.999 0.9999"
export embedders="GNN"
export gpu=3


for lamb in $lambda_list
do
for lp_alpha in $lp_alpha_list
do
python main.py --dataset PubMed --missing_rate 1.0 --embedder PPL_contrastive_test_2 --filling_method fp --lamb ${lamb} --lp_alpha ${lp_alpha} --n_runs 10 --missing_type uniform --gpu ${gpu}
done
done