#!/bin/bash
export datasets="wikics cs physics"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=3

for dataset in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method zero --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method neighborhood_mean --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset ${dataset} --missing_rate ${missing_rate} --embedder GNN --filling_method fp --n_runs 10 --missing_type uniform --gpu ${gpu}
done
done