#!/bin/bash
export datasets_="Cora CiteSeer PubMed wikics cs physics"
export datasets="Cora CiteSeer PubMed"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export _lambda_list="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export _missing_rates="0.0 1.0"
export lambda_list="0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=1

# python main.py --dataset Cora --lp_alpha 0.8 --lamb 0.0 --missing_rate 0.999 --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}
# python main.py --dataset Cora --lp_alpha 0.9 --lamb 0.0 --missing_rate 0.999 --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}
# python main.py --dataset Cora --lp_alpha 0.99 --lamb 0.0 --missing_rate 0.999 --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}
# python main.py --dataset Cora --lp_alpha 0.999 --lamb 0.0 --missing_rate 0.999 --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}


for lamb in $lambda_list
do
python main.py --dataset Cora --lp_alpha 0.9 --lamb ${lamb} --missing_rate 0.999 --embedder GOODIE --n_runs 10 --missing_type uniform --gpu ${gpu}
done