#!/bin/bash
export datasets="wikics cs"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_1="0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_2="0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_3="0.0 0.999 0.9999 1.0"
export lambda_list="0.0001"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=1

for lamb in $lambda_list
do
for missing_rate in $missing_rates_3
do
python main.py --dataset Cora --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.99 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset CiteSeer --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset PubMed --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.99 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset physics --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.9 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
python main.py --dataset OGBN-Arxiv --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.8 --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu ${gpu}
done
done

for lamb in $lambda_list
do
for missing_rate in $missing_rates_3
do
python main.py --dataset Cora --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.99 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset CiteSeer --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset PubMed --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.99 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset physics --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset wikics --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.9 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset OGBN-Arxiv --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.8 --lamb ${lamb} --n_runs 10 --missing_type structural --gpu ${gpu}
done
done