#!/bin/bash
export datasets="Cora"
export missing_rates="0.0"
export lambda_list="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export lp_alpha=0.99
export gpu=3


for lamb in $lambda_list
do
python main.py --dataset Cora --missing_rate 0.999 --lp_alpha 0.99 --embedder GOODIE --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu 3
done

for lamb in $lambda_list
do
python main.py --dataset Cora --missing_rate 0.999 --lp_alpha 0.99 --embedder GOODIE --lamb ${lamb} --n_runs 10 --missing_type structural --gpu 3
done

for lamb in $lambda_list
do
python main.py --dataset CiteSeer --missing_rate 0.999 --lp_alpha 0.999 --embedder GOODIE --lamb ${lamb} --n_runs 10 --missing_type uniform --gpu 3
done

for lamb in $lambda_list
do
python main.py --dataset CiteSeer --missing_rate 0.999 --lp_alpha 0.999 --embedder GOODIE --lamb ${lamb} --n_runs 10 --missing_type structural --gpu 3
done