import numpy as np
import os
import torch
import h5py
import IPython
import pandas as pd
import math
def processRaw(rawdir, scale):

    # df = pd.read_csv("LD2011_2014.txt", sep=";")
    df = pd.read_csv(os.path.join(rawdir, "raw", "LD2011_2014.txt"), sep=";")
    data = df.iloc[:, 1:]
    data = data.applymap(lambda x: float(str(x).replace(",", ".")))
    data = data.to_numpy()

    # dates = df.iloc[:, 0]
    # dates = dates.to_numpy()

    m = 370
    d_a = 9
    d_b = 1  # 11
    A_combo = torch.zeros((400, m, d_a))
    B_combo = torch.zeros((400, m, d_b))

    # pos = 0

    pos = 36904

    for i in range(400):
        print(i)

        A = np.zeros((m, d_a))
        B = np.zeros((m, d_b))
        for j in range(9):
            A[:, j] = data[pos, :].T
            pos += 1
        B[:, 0] = data[pos, :].T
        pos += 1

        AM = torch.from_numpy(A)
        U, Sig, V = torch.svd(AM)
        AM = AM / (Sig[0] / 100)

        BM = torch.from_numpy(B)
        U, Sig, V = torch.svd(BM)
        BM = BM / (Sig[0] / 100)
        A_combo[i] = AM
        B_combo[i] = BM


    N = A_combo.size()[0]
    print("N", N)
    split_pt = math.ceil(N * 0.8)
    A_train = A_combo[:split_pt]
    A_test = A_combo[split_pt:]
    B_train = B_combo[:split_pt]
    B_test = B_combo[split_pt:]

    # torch.save([A_train, B_train], "train_" + str(N) + ".dat")  # Ele_
    # torch.save([A_test, B_test], "test_" + str(N) + ".dat")  # Ele_

    torch.save([A_train, B_train], os.path.join(rawdir, "raw", "electric", "train_" + str(N) + ".dat"))
    torch.save([A_test, B_test], os.path.join(rawdir, "raw", "electric", "test_" + str(N) + ".dat"))

def getElectric(raw,rawdir,scale):
    if raw:
        N = processRaw(rawdir,scale)

    N = 400
    # print("Set N as variable here")
    # IPython.embed()
    AB_train = torch.load(os.path.join(rawdir,"raw", "electric", "train_"+str(N) + ".dat"))
    AB_test = torch.load(os.path.join(rawdir,"raw", "electric", "test_"+str(N) + ".dat"))
    n = AB_train[0][0].size()[0]
    d_a = AB_train[0][0].size()[1]
    d_b = AB_train[1][0].size()[1]
    # IPython.embed()
    # 950 50 50
    return AB_train, AB_test, n, d_a, d_b
