# Step 1: Install requirements.
# pip install torch
# pip install torchvision


# Step 2: Check nvidia and nvcc versions
nvidia-smi
nvcc --version


# Step 3: Copy the above tar files to the following point
INPUT_FOLDER=datasets/


# Step 4: Create output directory. I will store the output in this directory. 
OUTPUT_PARENT=output/
OUTPUT_FOLDER=$OUTPUT_PARENT/student_cub/


# Step 5 : Workspace directory (I assume the code submitted is placed here)
WORKSPACE_DIR=/mnt/workspace/projects/to-smooth-or-not-to-smooth/


# Step 6: Define hyper-parameters
NUM_GPUS=1
BATCH_SIZE=256
WORKERS=4
TEMPARATURES=(2.0 1.0 3.0 64.0)
MODELS=(resnet18)
TEACHER_ALPHAS=(0.1 0.0)
WEIGHTS_PARENT_PATH=teacher_weights/cub/
USE_AMP=1 # 1 if need to use amp, 0 if need to use fp32
WANDB_PROJECT_NAME=<INSERT HERE>
SEED=4021

# >> From this step, python code will run. 
cd $WORKSPACE_DIR/
mkdir $OUTPUT_PARENT
mkdir $OUTPUT_FOLDER

for MODEL in ${MODELS[*]}; do
    for T in ${TEMPARATURES[*]}; do
        for TEACHER_ALPHA in ${TEACHER_ALPHAS[*]}; do
            python src/cub/train_student.py $INPUT_FOLDER --output_dir=$OUTPUT_FOLDER --gpus=$NUM_GPUS -a=$MODEL -b=$BATCH_SIZE \
                -j=$WORKERS --dist-url 'tcp://127.0.0.1:1080' --dist-backend 'nccl' --multiprocessing-distributed --world-size 1 --rank 0 \
                --teacher_weights_path=$WEIGHTS_PARENT_PATH/cub-teacher\=resnet50-$TEACHER_ALPHA-best.pth.tar \
                --temperature=$T --teacher_alpha=$TEACHER_ALPHA --pretrained --use_amp=$USE_AMP \
                --exp_name=$WANDB_PROJECT_NAME --seed=$SEED
        done
    done
done