
# Step 1: Install requirements.
#pip3 install -r requirements.txt


# Step 2: Check nvidia and nvcc versions
nvidia-smi
nvcc --version


# Step 4: Copy the above tar files to the following point
INPUT_FOLDER=datasets/


# Step 8: Create output directory. I will store the output in this directory. 
OUTPUT_PARENT=output/
OUTPUT_FOLDER=$OUTPUT_PARENT/teacher_cub/


# Step 6 : Workspace directory (I assume the code submitted is placed here)
WORKSPACE_DIR=/mnt/workspace/projects/to-smooth-or-not-to-smooth/


# Step 7: Define hyper-parameters
NUM_GPUS=1
BATCH_SIZE=256
WORKERS=8
ALPHAS=(0.1 0.0)
MODELS=(resnet50)
WEIGHTS_PARENT_PATH=teacher_weights/imagenet/
USE_AMP=1 # 1 if need to use amp, 0 if need to use fp32
WANDB_PROJECT_NAME=<INSERT HERE>


# >> From this step, python code will run. 
cd $WORKSPACE_DIR/
mkdir $OUTPUT_PARENT
mkdir $OUTPUT_FOLDER

for MODEL in ${MODELS[*]}; do
    for ALPHA in ${ALPHAS[*]}; do
        echo $MODEL/$ALPHA
        python src/cub/train_teacher.py $INPUT_FOLDER --output_dir=$OUTPUT_FOLDER --gpus=$NUM_GPUS --alpha="$ALPHA" -a=$MODEL -b=$BATCH_SIZE \
            -j=$WORKERS --dist-url 'tcp://127.0.0.1:8080' --dist-backend 'nccl' --multiprocessing-distributed --world-size 1 --rank 0 \
            --pretrained --imagenet_weights_path=$WEIGHTS_PARENT_PATH/teacher\=resnet50-$ALPHA-best.pth.tar --use_amp=$USE_AMP \
            --exp_name=$WANDB_PROJECT_NAME --epochs=90
    done
done