# Step 1: Install requirements.
# pip install torch
# pip install torchvision


# Step 2: Check nvidia and nvcc versions
nvidia-smi
nvcc --version


# Step 3: Network dataset mount points for ImageNet train and validation tar files
#DATASET_MOUNT_POINT_TRAIN=/mnt/data/imagenet2012/ILSVRC2012_img_train.tar # This should be 138GB
#DATASET_MOUNT_POINT_VAL=/mnt/data/imagenet2012/ILSVRC2012_img_val.tar # This should be 6.7GB


# Step 4: Copy the above tar files to the following point
INPUT_FOLDER=/mnt/data/imagenet/
# mkdir $INPUT_FOLDER
# cp -r $DATASET_MOUNT_POINT_TRAIN $INPUT_FOLDER
# cp -r $DATASET_MOUNT_POINT_VAL $INPUT_FOLDER


# Step 5: Create train and val folders
#INPUT_FOLDER_TRAIN=$INPUT_FOLDER/train/
#INPUT_FOLDER_VAL=$INPUT_FOLDER/val/


# Step 6: Extract the train tar files to create Imagenet train dataset
# mkdir $INPUT_FOLDER_TRAIN && mv $INPUT_FOLDER/ILSVRC2012_img_train.tar $INPUT_FOLDER_TRAIN && cd $INPUT_FOLDER_TRAIN
# tar -xvf ILSVRC2012_img_train.tar && rm -f ILSVRC2012_img_train.tar
# find . -name "*.tar" | while read NAME ; do mkdir -p "${NAME%.tar}"; tar -xvf "${NAME}" -C "${NAME%.tar}"; rm -f "${NAME}"; done
# cd ..


# Step 7: Extract the val tar files to create Imagenet val dataset
#mkdir $INPUT_FOLDER_VAL && mv $INPUT_FOLDER/ILSVRC2012_img_val.tar $INPUT_FOLDER_VAL && cd $INPUT_FOLDER_VAL && tar -xvf ILSVRC2012_img_val.tar
#wget -qO- https://raw.githubusercontent.com/soumith/imagenetloader.torch/master/valprep.sh | bash
#rm -rf $INPUT_FOLDER_VAL/ILSVRC2012_img_val.tar


# Step 8: Create output directory. I will store the output in this directory. 
# Please return the contents of this directory after the experiment
OUTPUT_PARENT=output/
OUTPUT_FOLDER=$OUTPUT_PARENT/student_imagenet/


# Step 6 : Workspace directory (I assume the code submitted is placed here)
WORKSPACE_DIR=/mnt/workspace/projects/to-smooth-or-not-to-smooth/


# Step 7: Define hyper-parameters
NUM_GPUS=1
BATCH_SIZE=256 # This should be NUM_GPUS * 256
WORKERS=8
TEMPARATURES=(64.0)
MODELS=(resnet18)
TEACHER_ALPHAS=(0.1)
WEIGHTS_PARENT_PATH=teacher_weights/imagenet/
EPOCHS=10
WANDB_PROJECT_NAME=iclr-imagenet-debug


# >> From this step, python code will run. 
cd $WORKSPACE_DIR/
mkdir $OUTPUT_PARENT
mkdir $OUTPUT_FOLDER

for MODEL in ${MODELS[*]}; do
    for T in ${TEMPARATURES[*]}; do
        for TEACHER_ALPHA in ${TEACHER_ALPHAS[*]}; do
            python -m torch.distributed.launch --nproc_per_node=$NUM_GPUS src/imagenet/train_student.py -a $MODEL --dali_cpu \
            --b $BATCH_SIZE --loss-scale 128.0 --workers $WORKERS --lr=0.1 --opt-level O0 $INPUT_FOLDER \
            --temperature=$T --teacher_alpha=$TEACHER_ALPHA \
            --teacher_weights_path=$WEIGHTS_PARENT_PATH/teacher\=resnet50-$TEACHER_ALPHA-best.pth.tar \
            --exp_name=$WANDB_PROJECT_NAME --epochs=$EPOCHS --output_dir=$OUTPUT_FOLDER
        done
    done
done