# =================== ImageNet LS experiments =======================

# Step 1: Install requirements.
pip install torch
pip install torchvision


# Step 2: Check nvidia and nvcc versions
nvidia-smi
nvcc --version


# Step 4: Copy the above tar files to the following point
INPUT_FOLDER=/mnt/data/imagenet/


# Step 5: Create train and val folders
INPUT_FOLDER_TRAIN=$INPUT_FOLDER/train/
INPUT_FOLDER_VAL=$INPUT_FOLDER/val/


# Step 6: Extract the train tar files to create Imagenet train dataset
mkdir $INPUT_FOLDER_TRAIN && mv $INPUT_FOLDER/ILSVRC2012_img_train.tar $INPUT_FOLDER_TRAIN && cd $INPUT_FOLDER_TRAIN
tar -xvf ILSVRC2012_img_train.tar && rm -f ILSVRC2012_img_train.tar
find . -name "*.tar" | while read NAME ; do mkdir -p "${NAME%.tar}"; tar -xvf "${NAME}" -C "${NAME%.tar}"; rm -f "${NAME}"; done
cd ..


# Step 7: Extract the val tar files to create Imagenet val dataset
mkdir $INPUT_FOLDER_VAL && mv $INPUT_FOLDER/ILSVRC2012_img_val.tar $INPUT_FOLDER_VAL && cd $INPUT_FOLDER_VAL && tar -xvf ILSVRC2012_img_val.tar
wget -qO- https://raw.githubusercontent.com/soumith/imagenetloader.torch/master/valprep.sh | bash
rm -rf $INPUT_FOLDER_VAL/ILSVRC2012_img_val.tar


# Step 8: Create output directory. I will store the output in this directory. 
OUTPUT_FOLDER=results_imagenet/


# Step 6 : Workspace directory (I assume the code submitted is placed here)
WORKSPACE_DIR=/mnt/workspace/projects/to-smooth-or-not-to-smooth/


# Step 7: Define hyper-parameters
NUM_GPUS=-1
BATCH_SIZE=256
WORKERS=8
ALPHAS=(0.05 0.10 0.20 0.30)
MODELS=(resnet50)


# >> From this step, python code will run. 
cd $WORKSPACE_DIR/
mkdir $OUTPUT_FOLDER

for MODEL in ${MODELS[*]}; do
    for ALPHA in ${ALPHAS[*]}; do
        echo $MODEL/$ALPHA
        python src/imagenet/train_teacher.py $INPUT_FOLDER --output_dir=$OUTPUT_FOLDER --gpus=$NUM_GPUS --alpha="$ALPHA" -a=$MODEL -b=$BATCH_SIZE \
            -j=$WORKERS --dist-url 'tcp://127.0.0.1:8080' --dist-backend 'nccl' --multiprocessing-distributed --world-size 1 --rank 0
    done
done