# Exploring in Extremely Dark: Low-Light Video Enhancement with Real Events

Official PyTorch implementation of Exploring in Extremely Dark: Low-Light Video Enhancement with Real Events.

![图片](./Figures/REN.png)

## Introduction
Due to the limitations of sensor, traditional cameras struggle to capture details within extremely dark areas of videos. The absence of such details can significantly impact the effectiveness of low-light video enhancement. In contrast, event cameras offer a visual representation with higher dynamic range, facilitating the capture of motion information even in exceptionally dark conditions. Motivated by this advantage, we propose the Real-Event Embedded Network for low-light video enhancement. To better utilize events for enhancing extremely dark regions, we propose a Dark Region Selection module and an Event-Image Attention Fusion module, which can identify these dark regions and enhance them significantly. To ensure temporal stability of the video and restore details within extremely dark areas, we design unsupervised temporal consistency loss and detail contrast loss. Alongside the supervised loss, these loss functions collectively contribute to the semi-supervised training of the network on real data. Experimental results on synthetic and real data demonstrate the superiority of the proposed method compared to the state-of-the-art methods.

## Note
We have hidden the core code for now, and this part of the code will be made public after the paper is accepted. 

## Getting Start
Install dependencies:
```bash
cd code

# create new anaconda env
conda create -n REN python=3.7 -y
conda activate REN

# install python dependencies
pip install -r requirements.txt
```

## Test

If you want to enhance your low-light frames with our model, just run like this:
```python
python test.py --opt configs\test\SDSD_indoor_event.yml
or
python test.py --opt configs\test\SDSD_outdoor_event.yml
```

## Train

To train the entire network:, just run like this:
```python
python train.py --opt configs\train\SDSD_indoor_event.yml
or
python train.py --opt configs\train\SDSD_outdoor_event.yml
```

## Citation

If you find our work useful, please cite our paper by the following: