% This is the code for the NeurIPS'25 paper (spotlight):
% "An Efficient Orlicz-Sobolev Approach for Transporting Unbalanced Measures on a Graph"
% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


% Third-party toolbox
% + Sobolev transport
% + Unbalanced Sobolev transport
% + Generalized Sobolev transport
% + Sinkhorn_log


% Using the third-party toolbox to create the graphs G_Log and G_Sqrt
% amazon_OT_1000_RandLLE.mat (G_Log)
% amazon_OT_1000_RandSLE.mat (G_Sqrt)
% For examples:
% -- For building random graph (G_Log / G_Sqrt) from support data points
% (Sobolev transport third-party toolbox)
% + clusteringDataset_buildRandomGraph_Log: build random connected graph G_Log (M
% nodes, and M log(M) edges)
% + clusteringDataset_buildRandomGraph_Sqrt: build random connected graph
% G_Sqrt (M nodes, and M^(3/2) edges)


% Compute_Opt1D_OST_EXP1_vec_V3: compute 1D-optimization problem for OST with phi1 = @(X) exp(X) - X - 1;
% Compute_Opt1D_OST_EXP2_vec_V3: compute 1D-optimization problem for OST with phi2 = @(X) exp(X.^2) - 1;
% OrliczEPT: compute Orlicz-EPT


% Samples
% + test_opt1d_ost_exp1_all : for 1D-optimization problem for OST with phi1
% + test_opt1d_ost_exp2_all : for 1D-optimization problem for OST with phi2

% + test_OrliczEPT_Phi1.m : for Orlicz-EPT with phi1
% + test_OrliczEPT_Phi2.m : for Orlicz-EPT with phi2


% Data:
% amazon_ID10000.mat: the 10K random pairs


% Time consumption for OST and Orlicz-EPT with phi1, phi2 and limit case
% phi0
% + time_OST_EXP1_V3_1T : OST-phi1
% + time_OST_EXP2_V3_1T : OST-phi2
% + time_OST_Phi0_V3_1T : OST-phi0 (limit case)
% + time_OrliczEPT_EXP1_GraphMetric : Orlicz-EPT-phi1
% + time_OrliczEPT_EXP1_GraphMetric : Orlicz-EPT-phi2
% + time_OrliczEPT_Phi0_GraphMetric : Orlicz-EPT-phi0 (limit case)


% -- Note:
% + The code uses Graph and Network Algorithms from MATLAB. (e.g., Dijkstra
% algorithm for shortest path from a source point to a destination set of
% points.
% + The code uses Optimization Toolbox from MATLAB. (e.g., fmincon to solve
% the univariate optimization problem for 1d-optimization problem in OST).



