function val = OrliczEPT(phi, invphi, mu, nu, maxL, mu_hat, nu_hat, c_hat, b, lambda, epsilon, tol)

constEPS = 1e-20;

if nargin < 7
    tol = 1e-6;
end

if nargin < 6
    epsilon = 0.1;
end

% phi: vectorize for a matrix
% invphi: only need for a scalar

dotp = @(x,y)sum(x(:).*y(:));
H = @(p)-sum( p(:).*(log(p(:)+constEPS)-1) );
options.niter = 1e+4; 
options.tau = 0;
options.verb = 0;

x_right = maxL / invphi(1 + epsilon);

[~,~,gamma] = sinkhorn_log(mu_hat,nu_hat,c_hat,epsilon,options);
ss = dotp(gamma, c_hat) - epsilon*H(gamma);
x_left = (ss + (0.5*epsilon*(H(mu_hat) + H(nu_hat))))/invphi(1 + epsilon*(H(mu_hat) + H(nu_hat) - 1));

iter = 1;
while (x_right - x_left > tol)
    
    disp(['...' num2str(iter)]);

    x_mid = (x_left + x_right)/2;
    cx_mid = phi(c_hat ./ x_mid);
    [~,~,gamma] = sinkhorn_log(mu_hat,nu_hat,cx_mid,epsilon,options);
    fx_mid = dotp(gamma, cx_mid);

    if (fx_mid <= 1)
        x_right = x_mid;
        if abs(fx_mid - 1) <= constEPS
            break;
        end
    else
        x_left = x_mid;
    end

    iter = iter + 1;
end

val = (x_right - b*lambda)*(sum(mu) + sum(nu));

end



