## TimeInf: Time Series Data Contribution via Influence Functions

#### Code Structure

- time_series_influences: 
	- influence_functions.py: This contains code for computing TimeInf using linear AR models.
	- nonparametric_influences.py: This contains code for computing nonparametric TimeInf for non-differentiable models.
	- utils.py: This contains code for partitioning time series into overlapping blocks.
	- anomaly_detection.py: This contains code for calculating the anomaly scores and eval functions for computing various metrics, e.g., AUC, F1.
- anomaly_detection:
	- data_preprocess.py: This contains code for preprocessing anomaly detection datasets.
	- detectors.py: This contains code for all baseline anomaly detectors, including TimeInf, Isolation Forest, LSTM, anomaly transformer, etc..
	- main_XXX.py: This contains code for running anomaly detection experiment on a specific dataset.
	- Anomaly_Transformer: This folder contains adapted code from the original anomaly transformer git repo.
	- LSTM: This folder contains adapted code for implementing the LSTM anomaly detector.
- data_pruning:
	- utils_eval.py: This contains code for evaluating the data pruning experiment.
	- experiment.py: This contains code for measuring the importance of time points using different baselines, e.g., Data Shapley, DataOOB, etc..
- torch_influence: This folder contains adapted code for computing TimeInf using differentiable black-box models, e.g., RNN, LSTM.




