
import random

import numpy as np
import torch


def set_seed(seed: int = 0) -> None:
    """set seed for all components

    Parameters
    ----------
    seed : int, optional
        seed value, by default 0
    """
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.backends.cudnn.deterministic = True

    return
