import torch as th
import numpy as np
import os 

def get_prompt(placeholder,scenario='3m', prompt_type='traj',saved_exmple_path='prompt_example') :       
    base_prompt_path = '{}/{}/{}_prompt.txt'.format(saved_exmple_path,scenario,prompt_type)
    #base_prompt_path = '{}/{}/{}_prompt_final_only.txt'.format(saved_exmple_path,scenario,prompt_type)
    with open(base_prompt_path,'r',encoding='utf-8') as file :
        base_prompt = file.read()
        
        for key in placeholder :
            base_prompt = base_prompt.replace('[{}]'.format(key),str(placeholder[key]))
        
        final_prompt = base_prompt
    return final_prompt

def get_GRF_traj_placeholder(num_1,num_2,scenario='',save_traj_dir='replay_buffer/model_1_1') :
    traj_1 = dict()
    scheme = ['state','terminated','actions']
    for key in scheme :
        traj_1[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num_1,key))

    traj_2 = dict()

    for key in scheme :
        traj_2[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num_2,key))

    traj = [traj_1, traj_2]
    
    end_1 = th.where(traj_1['terminated']==1)[1].item()
    end_2 = th.where(traj_2['terminated']==1)[1].item()
    end_state = [end_1,end_2]    
    
    placeholder = dict()
    placeholder['scenario'] = scenario
    if scenario == 'academy_counterattack_easy' :
        n_f_agents = 4
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '1 (A goal keeper)'
        placeholder['Detailed_description'] = "4 versus 1 counter-attack with keeper. Victory is achieved when friendly agents pass the ball to each other and score a goal in the opponent's goal."
    elif scenario == 'academy_counterattack_hard' :
        n_f_agents = 4
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '2 (One field player and One goal keeper)'
        placeholder['Detailed_description'] = "4 versus 2 counter-attack with keeper. Victory is achieved when friendly agents pass the ball to each other and score a goal in the opponent's goal."
    elif scenario == 'academy_pass_and_shoot_with_keeper' :
        n_f_agents = 2
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '2 (One field player and One goal keeper)'
        placeholder['Detailed_description'] = "Two of our players try to score from the edge of the box, one is on the side with the ball, and next to a defender. The other is at the center, unmarked, and facing the opponent keeper. Victory is achieved when friendly agents pass the ball to each other and score a goal in the opponent's goal."
    elif scenario == 'academy_run_pass_and_shoot_with_keeper' :
        n_f_agents = 2
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '2 (One field player and One goal keeper)'
        placeholder['Detailed_description'] = "Two of our players try to score from the edge of the box, one is on the side with the ball, and unmarked. The other is at the center, next to a defender, and facing the opponent keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."
    elif scenario == 'academy_3_vs_1_with_keeper' :
        n_f_agents = 3
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '1 (A goal keeper)'
        placeholder['Detailed_description'] = "Three of our players try to score from the edge of the box, one on each side, and the other at the center. Initially, the player at the center has the ball and is facing the defender. There is an opponent keeper. Victory is achieved when friendly agents pass the ball to each other and score a goal in the opponent's goal."


    for idx in range(0,2) :
        s = traj[idx]['state'][0,:end_state[idx]+2,:]
        a = traj[idx]['actions'][0,:end_state[idx]+2,:]
        n_pass = 0
        n_pass_success = 0
        n_dribble = 0
        n_dribble_success = 0 
        n_shots = 0
        ball_possession_time = 0
        for t in range(end_state[idx]+1) :
            ball_position = [s[t,88].item(),s[t,89].item()]
            agents_position = list()
            dist_from_ball = list()
            for i in range(n_f_agents) :
                agent_idx = th.argmax(s[t,97+115*i:108+115*i]).item()
                x = s[t,agent_idx*2].item()
                y = s[t,agent_idx*2+1].item()
                agents_position.append([x,y])
                dist_from_ball.append(((ball_position[0]-x)**2+(ball_position[1]-y)**2)**0.5)   
            if s[t,95] == 1 :
                ball_possession = True
                possession_agent = th.argmin(th.tensor(dist_from_ball))
                action = a[t,possession_agent,0].item()
                if action == 9 or action == 10 or action == 11 :
                    n_pass += 1               
                    if s[t+1,95] == 1 :
                        n_pass_success+=1                    
                elif action == 13 or action == 17 :
                    n_dribble += 1               
                    if s[t+1,95] == 1 :
                        n_dribble_success+=1                    
                elif action == 12 :
                    n_shots += 1 
                    
                ball_possession_time+=1
        ball_position = [s[end_state[idx]+1,88].item(),s[end_state[idx]+1,89].item()]
        final_distance = round(((1-ball_position[0])**2+ball_position[1]**2)**0.5,2)
        placeholder['info_{}_1'.format(idx+1)] = n_pass
        placeholder['info_{}_2'.format(idx+1)] = n_pass_success
        placeholder['info_{}_3'.format(idx+1)] = n_dribble
        placeholder['info_{}_4'.format(idx+1)] = n_dribble_success
        placeholder['info_{}_5'.format(idx+1)] = n_shots
        placeholder['info_{}_6'.format(idx+1)] = ball_possession_time
        placeholder['info_{}_7'.format(idx+1)] = end_state[idx]+1
        placeholder['info_{}_8'.format(idx+1)] = final_distance

    return placeholder

def get_traj_placeholder(num_1,num_2,scenario='3m',save_traj_dir='replay_buffer/model_1_1') :
    
    traj_1 = dict()
    scheme = ['state','terminated']
    for key in scheme :
        traj_1[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num_1,key))

    traj_2 = dict()

    for key in scheme :
        traj_2[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num_2,key))

    traj = [traj_1, traj_2]
    
    '''
    if th.where(traj_1['terminated']==1)[1].item() >= th.where(traj_2['terminated']==1)[1].item() :
        end_1 = th.where(traj_2['terminated']==1)[1].item()
        end_2 = th.where(traj_2['terminated']==1)[1].item()
    else :
        end_1 = th.where(traj_1['terminated']==1)[1].item()
        end_2 = th.where(traj_1['terminated']==1)[1].item()
    '''
    
    end_1 = th.where(traj_1['terminated']==1)[1].item()
    end_2 = th.where(traj_2['terminated']==1)[1].item()
    
    '''
    if end_1 >= end_2 :
        end_1 = end_2
    else :
        end_2 = end_1
    '''
    
    end_state = [end_1,end_2]

    #traj_1['state'] = th.load(save_traj_dir+'/{}_state.pt'.format(num_1))

    if scenario == '3m' :
        n_agents = 3
        n_e_agents = 3
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
    elif scenario == '8m' :
        n_agents = 8
        n_e_agents = 8
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
    elif scenario == '25m' :
        n_agents = 25
        n_e_agents = 25
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
    elif scenario == '5m_vs_6m' :
        n_agents = 5
        n_e_agents = 6
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
    elif scenario == '3s_vs_4z' :
        n_agents = 3
        n_e_agents = 4
        a_step = 5
        e_step = 4 
        a_health_avg = True
        e_health_avg = True
    elif scenario == '3s_vs_5z' :
        n_agents = 3
        n_e_agents = 5
        a_step = 5
        e_step = 4 
        a_health_avg = True
        e_health_avg = True
    elif scenario == '3s_vs_3z' :
        n_agents = 3
        n_e_agents = 3
        a_step = 5
        e_step = 4 
        a_health_avg = True
        e_health_avg = True
    elif scenario == 'MMM' :
        n_agents = 10
        n_e_agents = 10
        a_step = 7
        e_step = 6 
        a_health_avg = False
        e_health_avg = False
    elif scenario == '2s3z' :
        n_agents = 5
        n_e_agents = 5
        a_step = 7
        e_step = 6 
        a_health_avg = True
        e_health_avg = True
    elif scenario == '6h_vs_8z' :
        n_agents = 6
        n_e_agents = 8
        a_step = 4
        e_step = 4 
        a_health_avg = False
        e_health_avg = True
    elif scenario == '2m_vs_1z' :
        n_agents = 2
        n_e_agents = 1
        a_step = 4
        e_step = 4 
        a_health_avg = False
        e_health_avg = True
    elif scenario == '2s_vs_1sc' :
        n_agents = 2
        n_e_agents = 1
        a_step = 5
        e_step = 3 
        a_health_avg = True
        e_health_avg = False
    elif scenario == '10gen_terran' :
        n_agents = 5
        n_e_agents = 5
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
    elif scenario == '10gen_zerg' :
        n_agents = 5
        n_e_agents = 5
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
    elif scenario == '10gen_protoss' :
        n_agents = 5
        n_e_agents = 5
        a_step = 8
        e_step = 7
        a_health_avg = True
        e_health_avg = True
    elif scenario == '11gen_terran' :
        n_agents = 5
        n_e_agents = 6
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
    elif scenario == '11gen_zerg' :
        n_agents = 5
        n_e_agents = 6
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
    elif scenario == '11gen_protoss' :
        n_agents = 5
        n_e_agents = 6
        a_step = 8
        e_step = 7
        a_health_avg = True
        e_health_avg = True
        

    
    placeholder = dict()
    for num in range(0,2) :
        ## Initial (i)
        n_live_a = 0 
        n_live_e = 0 
        h_all_a = 0 
        h_all_e = 0 
        for a_agent in range(n_agents) :
            placeholder[f'h_i_a_{a_agent+1}_t_{num+1}'] = round(traj[num]['state'][0,0][a_agent*a_step].item()*100,2)
            if traj[num]['state'][0,0][a_agent*a_step]*100 != 0 :
                n_live_a += 1
            h_all_a += traj[num]['state'][0,0][a_agent*a_step].item()*100

        for e_agent in range(n_e_agents) :
            placeholder[f'h_i_e_{e_agent+1}_t_{num+1}'] = round(traj[num]['state'][0,0][n_agents*a_step+e_agent*n_e_agents].item()*100,2)
            if traj[num]['state'][0,0][n_agents*a_step+e_agent*n_e_agents]*100 != 0 :
                n_live_e += 1
            h_all_e += traj[num]['state'][0,0][n_agents*a_step+e_agent*n_e_agents].item()*100

        placeholder[f'c_i_a_t_{num+1}'] = n_agents-n_live_a
        placeholder[f'c_i_e_t_{num+1}'] = n_e_agents-n_live_e
        placeholder[f'r_i_a_t_{num+1}'] = round(h_all_a,2)
        placeholder[f'r_i_e_t_{num+1}'] = round(h_all_e,2)

        ## Final (f)
        n_live_a = 0 
        n_live_e = 0 
        h_all_a = 0 
        h_all_e = 0 
        for a_agent in range(n_agents) :
            if a_health_avg :
                health = round((traj[num]['state'][0,end_state[num]][a_agent*a_step].item()+traj[num]['state'][0,end_state[num]][a_agent*a_step+4].item())*50,2)
            else :
                health = round(traj[num]['state'][0,end_state[num]][a_agent*a_step].item()*100,2)
            placeholder[f'h_f_a_{a_agent+1}_t_{num+1}'] = health
            if traj[num]['state'][0,end_state[num]][a_agent*a_step]*100 != 0 :
                n_live_a += 1
            h_all_a += health

        for e_agent in range(n_e_agents) :
            if e_health_avg :
                health = round((traj[num]['state'][0,end_state[num]][n_agents*a_step+e_agent*e_step].item()+traj[num]['state'][0,end_state[num]][n_agents*a_step+e_agent*e_step+3].item())*50,2)
            else :
                health = round(traj[num]['state'][0,end_state[num]][n_agents*a_step+e_agent*e_step].item()*100,2)
            placeholder[f'h_f_e_{e_agent+1}_t_{num+1}'] = health
            if traj[num]['state'][0,end_state[num]][n_agents*a_step+e_agent*e_step]*100 != 0 :
                n_live_e += 1
            h_all_e += health

        placeholder[f'c_f_a_t_{num+1}'] = n_agents-n_live_a
        placeholder[f'c_f_e_t_{num+1}'] = n_e_agents-n_live_e
        placeholder[f'r_f_a_t_{num+1}'] = round(h_all_a,2)
        placeholder[f'r_f_e_t_{num+1}'] = round(h_all_e,2)

        placeholder[f'step_{num+1}'] = end_state[num]
        
    return placeholder

def get_step_placeholder(num,step,scenario='3m',save_traj_dir='replay_buffer/model_1_1') :
    
    traj = dict()
    scheme = ['state','terminated','actions']
    if scenario == '3m' :
        n_agents = 3
        n_e_agents = 3
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3']
    elif scenario == '8m' :
        n_agents = 8
        n_e_agents = 8
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6','Attack Enemy7','Attack Enemy8']
    elif scenario == '25m' :
        n_agents = 25
        n_e_agents = 25
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6','Attack Enemy7','Attack Enemy8','Attack Enemy9','Attack Enemy10','Attack Enemy11','Attack Enemy12','Attack Enemy13','Attack Enemy14','Attack Enemy15','Attack Enemy16','Attack Enemy17','Attack Enemy18','Attack Enemy19','Attack Enemy20','Attack Enemy21','Attack Enemy22','Attack Enemy23','Attack Enemy24','Attack Enemy25']
    elif scenario == '5m_vs_6m' :
        n_agents = 5
        n_e_agents = 6
        a_step = 4
        e_step = 3 
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6']
    elif scenario == '3s_vs_4z' :
        n_agents = 3
        n_e_agents = 4
        a_step = 5
        e_step = 4 
        a_health_avg = True
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4']
    elif scenario == '3s_vs_5z' :
        n_agents = 3
        n_e_agents = 5
        a_step = 5
        e_step = 4 
        a_health_avg = True
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5']
    elif scenario == '3s_vs_3z' :
        n_agents = 3
        n_e_agents = 3
        a_step = 5
        e_step = 4 
        a_health_avg = True
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3']
    elif scenario == 'MMM' :
        n_agents = 10
        n_e_agents = 10
        a_step = 7
        e_step = 6 
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1(Marine)','Attack Enemy2(Marine)','Attack Enemy3(Marine)','Attack Enemy4(Marine)','Attack Enemy5(Medivac)','Attack Enemy6(Marauder)','Attack Enemy7(Marauder)','Attack Enemy8(Marine)','Attack Enemy9(Marine)','Attack Enemy10(Marine)']
        actions_2 = ['Dead','Stop','Move North','Move South','Move East','Move West','Heal Ally Agent1(Marauder)','Heal Ally Agent2(Marauder)','Heal Ally Agent3(Marine)','Heal Ally Agent4(Marine)','Heal Ally Agent5(Marine)','Heal Ally Agent6(Marine)','Heal Ally Agent7(Marine)','Heal Ally Agent8(Marine)','Heal Ally Agent9(Marine)','Heal Ally Agent10(Medivac)']
    elif scenario == '2s3z' :    
        n_agents = 5
        n_e_agents = 5
        a_step = 7
        e_step = 6 
        a_health_avg = True
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1(Stalker)','Attack Enemy2(Stalker)','Attack Enemy3(Zealot)','Attack Enemy4(Zealot)','Attack Enemy5(Zealot)']
    elif scenario == '6h_vs_8z' :
        n_agents = 6
        n_e_agents = 8
        a_step = 4
        e_step = 4 
        a_health_avg = False
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6','Attack Enemy7','Attack Enemy8']        
    elif scenario == '2m_vs_1z' :
        n_agents = 2
        n_e_agents = 1
        a_step = 4
        e_step = 4 
        a_health_avg = False
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1']
    elif scenario == '2s_vs_1sc' :
        n_agents = 2
        n_e_agents = 1
        a_step = 5
        e_step = 3 
        a_health_avg = True
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1']
    elif scenario == '10gen_terran' :
        n_agents = 5
        n_e_agents = 5
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5']
    elif scenario == '10gen_zerg' :
        n_agents = 5
        n_e_agents = 5
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5']
    elif scenario == '10gen_protoss' :
        n_agents = 5
        n_e_agents = 5
        a_step = 8
        e_step = 7
        a_health_avg = True
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5']
    elif scenario == '11gen_terran' :
        n_agents = 5
        n_e_agents = 6
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6']
    elif scenario == '11gen_zerg' :
        n_agents = 5
        n_e_agents = 6
        a_step = 7
        e_step = 6
        a_health_avg = False
        e_health_avg = False
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6']
    elif scenario == '11gen_protoss' :
        n_agents = 5
        n_e_agents = 6
        a_step = 8
        e_step = 7
        a_health_avg = True
        e_health_avg = True
        actions = ['Dead','Stop','Move North','Move South','Move East','Move West','Attack Enemy1','Attack Enemy2','Attack Enemy3','Attack Enemy4','Attack Enemy5','Attack Enemy6']
        
    for key in scheme :
        traj[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num,key))

    end_state = th.where(traj['terminated']==1)[1].item()
    
    placeholder = dict()
    for a_agent in range(n_agents) :
        if a_health_avg :
            health_1 = round((traj['state'][0,step][a_agent*a_step].item()+traj['state'][0,step][a_agent*a_step+4].item())*50,2)
            health_2 = round((traj['state'][0,step+1][a_agent*a_step].item()+traj['state'][0,step+1][a_agent*a_step+4].item())*50,2) 
        else :
            health_1 = round(traj['state'][0,step][a_agent*a_step].item()*100,2)
            health_2 = round(traj['state'][0,step+1][a_agent*a_step].item()*100,2) 
        placeholder[f'a_{a_agent+1}_x_1'] = round(traj['state'][0,step][2+a_agent*a_step].item(),2)
        placeholder[f'a_{a_agent+1}_y_1'] = round(traj['state'][0,step][3+a_agent*a_step].item(),2)
        placeholder[f'a_{a_agent+1}_h_1'] = health_1
        if a_agent == 9 and scenario == 'MMM' :
            placeholder[f'a_{a_agent+1}_a_1'] = actions_2[traj['actions'][0,step][a_agent]]
        else :
            placeholder[f'a_{a_agent+1}_a_1'] = actions[traj['actions'][0,step][a_agent]]
        
        placeholder[f'a_{a_agent+1}_x_2'] = round(traj['state'][0,step+1][2+a_agent*a_step].item(),2)
        placeholder[f'a_{a_agent+1}_y_2'] = round(traj['state'][0,step+1][3+a_agent*a_step].item(),2)
        placeholder[f'a_{a_agent+1}_h_2'] = health_2

    for e_agent in range(n_e_agents) :
        if e_health_avg :
            health_1 = round((traj['state'][0,step][e_agent*e_step+n_agents*a_step].item()+traj['state'][0,step][e_agent*e_step+n_agents*a_step+3].item())*50,2) 
            health_2 = round((traj['state'][0,step+1][e_agent*e_step+n_agents*a_step].item()+traj['state'][0,step+1][e_agent*e_step+n_agents*a_step+3].item())*50,2)
        else :
            health_1 = round(traj['state'][0,step][e_agent*e_step+n_agents*a_step].item()*100,2)
            health_2 = round(traj['state'][0,step+1][e_agent*e_step+n_agents*a_step].item()*100,2)
        placeholder[f'e_{e_agent+1}_x_1'] = round(traj['state'][0,step][1+e_agent*e_step+n_agents*a_step].item(),2)
        placeholder[f'e_{e_agent+1}_y_1'] = round(traj['state'][0,step][2+e_agent*e_step+n_agents*a_step].item(),2)
        placeholder[f'e_{e_agent+1}_h_1'] = health_1

        placeholder[f'e_{e_agent+1}_x_2'] = round(traj['state'][0,step+1][1+e_agent*e_step+n_agents*a_step].item(),2)
        placeholder[f'e_{e_agent+1}_y_2'] = round(traj['state'][0,step+1][2+e_agent*e_step+n_agents*a_step].item(),2)
        placeholder[f'e_{e_agent+1}_h_2'] = health_2
        
    return placeholder


def get_GRF_step_placeholder(num,step,scenario='3m',save_traj_dir='replay_buffer/model_1_1') :
    
    traj = dict()
    scheme = ['state','terminated','actions']
    actions = ['No-operation',
               'Move Left','Move Top Left','Move Top','Move Top Right',
               'Move Right','Move Bottom Right','Move Bottom','Move Bottom Left',
               'Long Pass','High Pass','Short Pass','Shot',
               'Sprint','Release direction','Release Sprint','Sliding',
               'Dribble','Release dribble']

    placeholder = dict()
    placeholder['scenario'] = scenario
    placeholder['Instruction'] = "Assign the lowest contribution to agents not in possession of the ball when they attempt actions related to the ball (such as pass, dribble, etc.)."
    
    if scenario == 'academy_counterattack_easy' :
        n_f_agents = 4
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '1 (A goal keeper)'
        placeholder['Detailed_description'] = "4 versus 1 counter-attack with keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."
    elif scenario == 'academy_counterattack_hard' :
        n_f_agents = 4
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '2 (One field player and One goal keeper)'
        placeholder['Detailed_description'] = "4 versus 2 counter-attack with keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."
    elif scenario == 'academy_pass_and_shoot_with_keeper' :
        n_f_agents = 2
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '2 (One field player and One goal keeper)'
        placeholder['Detailed_description'] = "Two of our players try to score from the edge of the box, one is on the side with the ball, and next to a defender. The other is at the center, unmarked, and facing the opponent keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."
    elif scenario == 'academy_run_pass_and_shoot_with_keeper' :
        n_f_agents = 2
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '2 (One field player and One goal keeper)'
        placeholder['Detailed_description'] = "Two of our players try to score from the edge of the box, one is on the side with the ball, and unmarked. The other is at the center, next to a defender, and facing the opponent keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."
    elif scenario == 'academy_3_vs_1_with_keeper' :
        n_f_agents = 3
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '1 (A goal keeper)'
        placeholder['Detailed_description'] = "Three of our players try to score from the edge of the box, one on each side, and the other at the center. Initially, the player at the center has the ball and is facing the defender. There is an opponent keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."

    for key in scheme :
        traj[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num,key))

    end_state = th.where(traj['terminated']==1)[1].item()
    
    s = traj['state'][0]
    a = traj['actions'][0]
    ball_position = [round(s[step,88].item(),2),round(s[step,89].item(),2)]
    placeholder['ball_x'] = ball_position[0]
    placeholder['ball_y'] = ball_position[1]
    dist = list()
    for i in range(n_f_agents) :
        agent_idx = th.argmax(s[step,97+115*i:108+115*i]).item()
        x = round(s[step,agent_idx*2].item(),2)
        y = round(s[step,agent_idx*2+1].item(),2)
        placeholder['a_{}_x_1'.format(i+1)] = x
        placeholder['a_{}_y_1'.format(i+1)] = y
        dist.append(((ball_position[0]-x)**2+(ball_position[1]-y)**2)**0.5)
        agent_action = a[step,i,0].item()
        placeholder['a_{}_a_1'.format(i+1)] = actions[agent_action]
    
    if s[step,94] == 1 :
        placeholder['ball_possession'] = "Neutral, nobody has possession of the ball"
    elif s[step,95] == 1 :
        possession_agent = th.argmin(th.tensor(dist))
        placeholder['ball_possession'] = "Friendly team has possession, specifically Agent {} has possession of the ball".format(str(possession_agent))
    elif s[step,96] == 1 :
        placeholder['ball_possession'] = "Opponent has possession of the ball"
        
    return placeholder

