def get_GRF_traj_placeholder(num_1,num2,scenario='',save_traj_dir='replay_buffer/model_1_1') :
    traj_1 = dict()
    scheme = ['state','terminated','action']
    for key in scheme :
        traj_1[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num_1,key))

    traj_2 = dict()

    for key in scheme :
        traj_2[key] = th.load(save_traj_dir+'/{}_{}.pt'.format(num_2,key))

    traj = [traj_1, traj_2]
    
    end_1 = th.where(traj_1['terminated']==1)[1].item()
    end_2 = th.where(traj_2['terminated']==1)[1].item()
    end_state = [end_1,end_2]    
    
    placeholder = dict()
    placeholder['scenario'] = scenario
    if scenario == 'academy_counterattack_easy' :
        n_f_agents = 4
        placeholder['n_f_agents'] = str(n_f_agents)
        placeholder['n_e_agents'] = '1 (A goal keeper)'
        placeholder['Detailed_description'] = "4 versus 1 counter-attack with keeper. Victory is achieved when friendly agents pass the ball to each other and score a gola in the opponent's goal."
  
    for idx in range(0,2) :
        s = traj[idx]['state'][0,:end_state[idx]+2,:]
        a = traj[idx]['action'][0,:end_state[idx]+2,:]
        n_pass = 0
        n_pass_success = 0
        n_dribble = 0
        n_dribble_success = 0 
        n_shots = 0
        ball_possession_time = 0
        for t in range(end_state[idx]+1) :
            ball_position = [s[t,88].item(),s[t,89].item()]
            agents_position = list()
            dist_from_ball = list()
            for i in range(n_f_agents) :
                agent_idx = th.argmax(s[t,97+115*i:108+115*i]).item()
                x = s[t,agent_idx*2].item()
                y = s[t,agent_idx*2+1].item()
                agents_position.append([x,y])
                dist_from_ball.append(((ball_position[0]-x)**2+(ball_position[1]-y)**2)**0.5)   
            if s[t,95] == 1 :
                ball_possession = True
                possession_agent = th.argmin(th.tensor(dist_from_ball))
                action = a[t,possession_agent,0].item()
                if action == 9 or action == 10 or action == 11 :
                    n_pass += 1               
                    if s[t+1,95] == 1 :
                        n_pass_success+=1                    
                elif action == 13 or action == 17 :
                    n_dribble += 1               
                    if s[t+1,95] == 1 :
                        n_dribble_success+=1                    
                elif action == 12 :
                    n_shots += 1 
                    
                ball_possession_time+=1
        ball_position = [s[end_state[idx]+1,88].item(),s[end_state[idx]+1,89].item()]
        final_distance = round(((1-ball_position[0])**2+ball_position[1]**2)**0.5,2)
        placeholder['info_{}_1'] = n_pass
        placeholder['info_{}_2'] = n_pass_success
        placeholder['info_{}_3'] = n_dribble
        placeholder['info_{}_4'] = n_dribble_success
        placeholder['info_{}_5'] = n_shots
        placeholder['info_{}_6'] = ball_possession_time
        placeholder['info_{}_7'] = end_state[idx]+1
        placeholder['info_{}_8'] = final_distance

    return placeholder