FILE=$1
if [[ -z $FILE ]]; then
    echo "Usage: $0 <file>"
    exit 1
fi
if [[ ! -f $FILE ]]; then
    echo "File $FILE does not exist"
    exit 1
fi
grep '^T' $FILE | cut -f2- | perl -ple 's{(\S)-(\S)}{$1 ##AT##-##AT## $2}g' > ${FILE%.*}.ref
grep '^H' $FILE | cut -f3- | perl -ple 's{(\S)-(\S)}{$1 ##AT##-##AT## $2}g' > ${FILE%.*}.sys
fairseq-score --ignore-case -r ${FILE%.*}.ref -s ${FILE%.*}.sys
