from openai import AsyncOpenAI
import asyncio

async def web_search_retrieve(prompt, model="gpt-4o", search_context_size="low"):
  """
  Retrieve web search results based on the input prompt.
  Args:
      model: The name of the model to use for generating the response.(some models do not support web search)
      prompt: User query to generate the response.
      search_context_size: The size of the retrieved search context from the web.
  Returns:
      The response generated by the model based on web search results.
  """
  aclient = AsyncOpenAI(api_key="")

  response =await aclient.responses.create(
      model=model,
      tools=[{"type": "web_search_preview",
              "search_context_size": search_context_size}],
      input = prompt
  )

  return response.output_text

async def main():
    query_with_web_retrieval = "Please tell me today's date and the chemistry news."
    print("Generation after web retrieval:")
    print(await web_search_retrieve(prompt=query_with_web_retrieval))
# Example usage:
if __name__ == '__main__':

    asyncio.run(main())
