# Differentially Private Federated Learning with Time-Adaptive Privacy Spending

This research library implements our work on time-adaptive differentially private federated learning.

## Abstract
Federated learning (FL) with differential privacy (DP) provides a theoretically
sound framework for collaborative machine learning, enabling clients to train a
shared model while adhering to strict privacy constraints. While this framework
inherently enables different clients to have individualized privacy guarantees, e.g.,
by adding different amounts of noise to their model updates, it still assumes that all
clients spend their privacy budgets uniformly over time (learning rounds). How-
ever, it has been shown in the literature that early rounds typically focus on more
coarse-grained features that can be learned under stronger noise while later rounds
learn fine-grained features that benefit from a higher signal-to-noise ratio. Build-
ing on this intuition, we propose a time-adaptive DP-FL framework which sup-
ports non-uniform privacy spending across both clients and rounds. Our frame-
work enables each client to save some privacy budget in the early rounds to spend
more in the future rounds when it is needed to learn more fine-grained features. As
part of our framework design, we introduce a privacy spending method, namely
“spend-as-you-go”, wherein clients spend their saved privacy budgets incremen-
tally over time. We theoretically prove utility improvements in the case that clients
with stricter privacy budgets spend budgets more unevenly across rounds, com-
pared to clients with more relaxed budgets, who have sufficient budgets for both
early and later rounds and can distribute their spending more evenly. Our prac-
tical experiments on standard benchmark datasets support theoretical proofs and
show that our algorithms, also in practice, improve the privacy-utility trade-offs
compared to the baselines.

## Development Flow

1. Create a suitable conda environment
2. Source this environment and activate it
   
3. Install the requirements and dependencies

   ```bash
   pip install -r requirements.txt

4. Run the experiment for baseline
   ```bash
   python main_scheme1_baseline.py --config config.yaml

5. Run the experiment for our time-adaptive DP-FL framework
   ```bash
   python main_scheme2_time_adaptive_dpfl.py --config config.yaml


## Code Structure
Scheme 1 is our baseline and implements DP-FedAvg (individualized DP-FedAvg which can be implemented by setting unequal epsilon values and srates and non-individualized DP-FedAvg can be implemented by setting equal epsilon values and srates in configuration file)
The experiments can be launched using `fl-experiments-code/main_scheme1_baseline.py`

Scheme 2, which builds on Scheme 1 considers non-uniform assignment of privacy budgets across clients and also across training iterations.
The experiments can be launched using `fl-experiments/main_scheme2_time_adaptive_dpfl.py`

Our configuration file - `fl-experiments/config.yaml` is as follows:
```bash
num_clients: 100
data_points_per_client: 600
rounds: 50
epochs: 30
runs: 3
sprint_rounds: 5
cprint_rounds: 10
lr: 0.001
bs: 125
epsilon1: 10
epsilon2: 15
epsilon3: 20
srate1: 0.3
srate2: 0.5
srate3: 0.7
clip_value: 250.0
sigma: 0.3
delta: 1e-5
sample_rate: 0.8
dataset: fmnist
privacy_spending1: 0.5
privacy_spending2: 0.5
privacy_spending3: 0.5
when_save: first
saving_rate: 0.6
niid: True
balance: True
partition: dir
rate: 0.9
device: cuda:1
