import os
import torch
import yaml
import numpy as np
import matplotlib.pyplot as plt


batch_size = 10
train_size = 0.75 
least_samples = batch_size / (1-train_size) 
alpha = 0.1 

def set_seed(seed=42):
    torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed(seed)
    np.random.seed(seed)

def load_config(config_path):
    with open(config_path, 'r') as f:
        config = yaml.safe_load(f)
    return config


def setup_files(num_clients, num_runs, num_rounds, num_epochs, sigma, clip_value, epsilons, sample_rate, name, flag_is_niid, dataset_name):
    results_dir = "results"
    privacy_dir = "privacy"
    accuracy_dir = "accuracy"
    plots_dir = "plots"
    niid_dir = "niid"
    iid_dir = "iid"

    privacy_dir_path = os.path.join(results_dir, privacy_dir)
    accuracy_dir_path = os.path.join(results_dir, accuracy_dir)
    plot_dir_path = os.path.join(results_dir, plots_dir)
    plot_niid_dir_path = os.path.join(plot_dir_path, niid_dir)
    plot_iid_dir_path = os.path.join(plot_dir_path, iid_dir)

    if not os.path.exists(privacy_dir_path):
        os.makedirs(privacy_dir_path)
    if not os.path.exists(accuracy_dir_path):
        os.makedirs(accuracy_dir_path)
    if not os.path.exists(plot_dir_path):
        os.makedirs(plot_dir_path)
    if not os.path.exists(plot_niid_dir_path):
        os.makedirs(plot_niid_dir_path)
    if not os.path.exists(plot_iid_dir_path):
        os.makedirs(plot_iid_dir_path)

    file_clients_privacy_spent = os.path.join(privacy_dir_path,
                                              name + "_" + dataset_name + "_" + "privacy_budget_" +
                                              "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                              + "clients_" + str(num_clients) + "_" +
                                              "sigma_" + "{:.2f}".format(sigma) + "_" +
                                              "clip_" + "{:.2f}".format(clip_value) + "_" +
                                              "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                              "runs_" + str(num_runs) + "_" +
                                              "rounds_" + str(num_rounds) + "_" +
                                              "epochs_" + str(num_epochs) + ".png")

    file_test_acc = os.path.join(accuracy_dir_path,
                                 name + "_" + dataset_name + "_" + "accuracy_" +
                                 "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                 + "clients_" + str(num_clients) + "_" +
                                 "sigma_" + "{:.2f}".format(sigma) + "_" +
                                 "clip_" + "{:.2f}".format(clip_value) + "_" +
                                 "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                 "runs_" + str(num_runs) + "_" +
                                 "rounds_" + str(num_rounds) + "_" +
                                 "epochs_" + str(num_epochs) + ".png")

    plot_niid_iid_dir_path = plot_iid_dir_path
    if flag_is_niid:
        plot_niid_iid_dir_path = plot_niid_dir_path

    file_plot_test_acc = os.path.join(plot_niid_iid_dir_path,
                                      name + "_" + dataset_name + "_" + "test_acc_" +
                                      "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                      + "clients_" + str(num_clients) + "_" +
                                      "sigma_" + "{:.2f}".format(sigma) + "_" +
                                      "clip_" + "{:.2f}".format(clip_value) + "_" +
                                      "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                      "runs_" + str(num_runs) + "_" +
                                      "rounds_" + str(num_rounds) + "_" +
                                      "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_train_loss = os.path.join(plot_niid_iid_dir_path,
                                                name + "_" + dataset_name + "_" + "train_loss_" +
                                                "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                + "clients_" + str(num_clients) + "_" +
                                                "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                "runs_" + str(num_runs) + "_" +
                                                "rounds_" + str(num_rounds) + "_" +
                                                "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_norm = os.path.join(plot_niid_iid_dir_path,
                                          name + "_" + dataset_name + "_" + "norm_" +
                                          "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                          + "clients_" + str(num_clients) + "_" +
                                          "sigma_" + "{:.2f}".format(sigma) + "_" +
                                          "clip_" + "{:.2f}".format(clip_value) + "_" +
                                          "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                          "runs_" + str(num_runs) + "_" +
                                          "rounds_" + str(num_rounds) + "_" +
                                          "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_privacy_spent = os.path.join(plot_niid_iid_dir_path,
                                                   name + "_" + dataset_name + "_" + "privacy_" +
                                                   "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                   + "clients_" + str(num_clients) + "_" +
                                                   "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                   "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                   "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                   "runs_" + str(num_runs) + "_" +
                                                   "rounds_" + str(num_rounds) + "_" +
                                                   "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_per_round_privacy_spent = os.path.join(plot_niid_iid_dir_path,
                                                             name + "_" + dataset_name + "_" + "perrndpri_" +
                                                             "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                             + "clients_" + str(num_clients) + "_" +
                                                             "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                             "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                             "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                             "runs_" + str(num_runs) + "_" +
                                                             "rounds_" + str(num_rounds) + "_" +
                                                             "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_per_round_noise_multiplier = os.path.join(plot_niid_iid_dir_path,
                                                             name + "_" + dataset_name + "_" + "perrndsig_" +
                                                             "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                                + "clients_" + str(num_clients) + "_" +
                                                                "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                                "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                                "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                                "runs_" + str(num_runs) + "_" +
                                                                "rounds_" + str(num_rounds) + "_" +
                                                                "epochs_" + str(num_epochs) + ".png")
    file_plot_clients_per_round_rdp_privacy_spent = os.path.join(plot_niid_iid_dir_path,
                                                                name + "_" + dataset_name + "_" + "perrndrdp_" +
                                                                "epsilons_" + str(epsilons[0]) + "_" + str(
                                                                    epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                                + "clients_" + str(num_clients) + "_" +
                                                                "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                                "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                                "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                                "runs_" + str(num_runs) + "_" +
                                                                "rounds_" + str(num_rounds) + "_" +
                                                                "epochs_" + str(num_epochs) + ".png")
    file_plot_clients_per_round_best_alpha = os.path.join(plot_niid_iid_dir_path,
                                                                 name + "_" + dataset_name + "_" + "perrndalp_" +
                                                                 "epsilons_" + str(epsilons[0]) + "_" + str(
                                                                     epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                                 + "clients_" + str(num_clients) + "_" +
                                                                 "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                                 "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                                 "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                                 "runs_" + str(num_runs) + "_" +
                                                                 "rounds_" + str(num_rounds) + "_" +
                                                                 "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_test_acc_local_model_local_data = os.path.join(plot_niid_iid_dir_path,
                                                                     name + "_" + dataset_name + "_" + "test_acc_lmld_" +
                                                                     "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                                     + "clients_" + str(num_clients) + "_" +
                                                                     "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                                     "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                                     "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                                     "runs_" + str(num_runs) + "_" +
                                                                     "rounds_" + str(num_rounds) + "_" +
                                                                     "epochs_" + str(num_epochs) + ".png")

    file_plot_clients_test_acc_global_model_local_data = os.path.join(plot_niid_iid_dir_path,
                                                                      name + "_" + dataset_name + "_" + "test_acc_gmld_" +
                                                                      "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                                      + "clients_" + str(num_clients) + "_" +
                                                                      "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                                      "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                                      "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                                      "runs_" + str(num_runs) + "_" +
                                                                      "rounds_" + str(num_rounds) + "_" +
                                                                      "epochs_" + str(num_epochs) + ".png")
    file_plot_clients_test_acc_local_model_global_data = os.path.join(plot_niid_iid_dir_path,
                                                                      name + "_" + dataset_name + "_" + "test_acc_lmgd_" +
                                                                      "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(epsilons[2]) + "_"
                                                                      + "clients_" + str(num_clients) + "_" +
                                                                      "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                                      "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                                      "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                                      "runs_" + str(num_runs) + "_" +
                                                                      "rounds_" + str(num_rounds) + "_" +
                                                                      "epochs_" + str(num_epochs) + ".png")
    return file_plot_clients_test_acc_local_model_local_data,  \
           file_plot_clients_test_acc_global_model_local_data, \
           file_plot_clients_test_acc_local_model_global_data, \
           file_plot_clients_norm, \
           file_plot_clients_train_loss, \
           file_plot_test_acc, \
           file_plot_clients_per_round_privacy_spent, \
           file_plot_clients_per_round_noise_multiplier, \
           file_plot_clients_per_round_rdp_privacy_spent, \
           file_plot_clients_per_round_best_alpha, \
           file_plot_clients_privacy_spent



def plot_results(clients_test_acc_local_model_local_data,
                 clients_test_acc_global_model_local_data,
                 clients_test_acc_local_model_global_data,
                 test_acc,
                 clients_norm,
                 global_clip_values,
                 local_clip_values,
                 clients_train_loss,
                 clients_privacy_spent,
                 clients_per_round_privacy_spent,
                 clients_per_round_noise_multiplier,
                 clients_per_round_rdp_privacy_spent,
                 clients_per_round_best_alpha,
                 file_clients_test_acc_local_model_local_data,
                 file_clients_test_acc_global_model_local_data,
                 file_clients_test_acc_local_model_global_data,
                 file_clients_norm,
                 file_clients_train_loss,
                 file_test_acc,
                 file_clients_privacy_spent,
                 file_clients_per_round_privacy_spent,
                 file_clients_per_round_noise_multiplier,
                 file_clients_per_round_rdp_privacy_spent,
                 file_clients_per_round_best_alpha,
                 num_clients,
                 clip_value,
                 epsilons,
                 sigma,
                 sample_rate, scheme, dataset_name):

    plt.figure(1)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    plt.plot(range(len(clients_norm)), clients_norm, label='norms')
    plt.plot(range(len(global_clip_values)), global_clip_values, label='global clip')
    plt.plot(range(len(local_clip_values)), local_clip_values, label='local clip')
    plt.xlabel('Global Rounds')
    plt.ylabel('Avg. Net-Wise Norm of Updates')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.legend()
    plt.savefig(file_clients_norm)
    plt.show()

    plt.figure(2)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    plt.plot(range(len(clients_train_loss)), clients_train_loss)
    plt.xlabel('Global Rounds')
    plt.ylabel('Avg. Training Loss')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.savefig(file_clients_train_loss)
    plt.show()

    plt.figure(3)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    plt.plot(range(len(test_acc)), test_acc)
    plt.xlabel('Global Rounds')
    plt.ylabel('Global Test Accuracy')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.savefig(file_test_acc)
    plt.show()

    plt.figure(4)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    for client_id in range(num_clients):
        plt.plot(range(len(clients_privacy_spent[client_id])), clients_privacy_spent[client_id],
                 label='client' + str(client_id))
    plt.xlabel('Global Rounds')
    plt.ylabel('Privacy spent')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.legend()
    plt.savefig(file_clients_privacy_spent)
    plt.show()

    plt.figure(5)
    plt.plot(range(len(clients_test_acc_local_model_local_data)), clients_test_acc_local_model_local_data)
    plt.xlabel('Global Rounds', fontsize=14)
    plt.ylabel('Avg. Test Acc. L-M L-D', fontsize=14)
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.savefig(file_clients_test_acc_local_model_local_data)
    plt.show()
    plt.close()

    plt.figure(6)
    plt.plot(range(len(clients_test_acc_global_model_local_data)), clients_test_acc_global_model_local_data)
    plt.xlabel('Global Rounds', fontsize=14)
    plt.ylabel('Avg. Test Acc. G-M L-D', fontsize=14)
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.savefig(file_clients_test_acc_global_model_local_data)
    plt.show()
    plt.close()

    plt.figure(7)
    plt.plot(range(len(clients_test_acc_local_model_global_data)), clients_test_acc_local_model_global_data)
    plt.xlabel('Global Rounds', fontsize=14)
    plt.ylabel('Avg. Test Acc. L-M G-D', fontsize=14)
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.savefig(file_clients_test_acc_local_model_global_data)
    plt.show()
    plt.close()

    plt.figure(8)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    for client_id in range(num_clients):
        plt.plot(range(len(clients_per_round_privacy_spent[client_id])), clients_per_round_privacy_spent[client_id],
                 label='client' + str(client_id))
    plt.xlabel('Global Rounds')
    plt.ylabel('Per-round Privacy spent')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.legend()
    plt.savefig(file_clients_per_round_privacy_spent)
    plt.show()

    plt.figure(9)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    for client_id in range(num_clients):
        plt.plot(range(len(clients_per_round_noise_multiplier[client_id])), clients_per_round_noise_multiplier[client_id],
                 label='client' + str(client_id))
    plt.xlabel('Global Rounds')
    plt.ylabel('Avg. Per-round Local Sigma')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.legend()
    plt.savefig(file_clients_per_round_noise_multiplier)
    plt.show()

    plt.figure(10)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    for client_id in range(num_clients):
        plt.plot(range(len(clients_per_round_rdp_privacy_spent[client_id])),
                 clients_per_round_rdp_privacy_spent[client_id],
                 label='client' + str(client_id))
    plt.xlabel('Global Rounds')
    plt.ylabel('Avg. Per-round RDP privacy spent')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.legend()
    plt.savefig(file_clients_per_round_rdp_privacy_spent)
    plt.show()

    plt.figure(11)
    plt.xlabel('X-axis', fontsize=14)
    plt.ylabel('Y-axis', fontsize=14)
    plt.tick_params(axis='both', labelsize=12)
    for client_id in range(num_clients):
        plt.plot(range(len(clients_per_round_best_alpha[client_id])),
                 clients_per_round_best_alpha[client_id],
                 label='client' + str(client_id))
    plt.xlabel('Global Rounds')
    plt.ylabel('Avg. Per-round best alpha')
    plt.title(f"S {scheme}, Epsilons {epsilons[0]}, {epsilons[1]}, {epsilons[2]}")
    plt.grid(True)
    plt.legend()
    plt.savefig(file_clients_per_round_best_alpha)
    plt.show()

def save_results_in_to_files(
    clients_test_acc_local_model_local_data,
    clients_test_acc_global_model_local_data,
    clients_test_acc_local_model_global_data,
    test_acc,
    clients_norm,
    global_clip_values,
    local_clip_values,
    clients_train_loss,
    clients_privacy_spent,
    clients_per_round_privacy_spent,
    clients_per_round_noise_multiplier,
    clients_per_round_rdp_privacy_spent,
    clients_per_round_best_alpha,
    num_clients,
    clip_value,
    epsilons,
    sigma,
    sample_rate,
    title,
    dataset_name,
    run,
    num_rounds,
    num_epochs
):

    results_dir = "results"
    privacy_spent_dir = "privacySpent"
    global_test_accuracy_dir = "globalTestAccuracy"
    train_loss_dir = "trainingLoss"
    norms_dir = "clientsNorm"
    noise_multiplier_dir = "noiseMultiplier"
    privacy_spent_per_rnd_dir = "privacySpentPerRound"
    rdp_privacy_spent_per_rnd_dir = "rdpPrivacySpentPerRound"
    test_acc_local_model_global_data_dir = "testAccuracyLMGD"

    privacy_spent_dir_path = os.path.join(results_dir, privacy_spent_dir)
    global_test_accuracy_dir_path = os.path.join(results_dir, global_test_accuracy_dir)
    training_loss_dir_path = os.path.join(results_dir, train_loss_dir)
    norms_dir_path = os.path.join(results_dir, norms_dir)
    noise_multiplier_dir_path = os.path.join(results_dir, noise_multiplier_dir)
    privacy_spent_per_rnd_dir_path = os.path.join(results_dir, privacy_spent_per_rnd_dir)
    rdp_privacy_spent_per_rnd_dir_path = os.path.join(results_dir, rdp_privacy_spent_per_rnd_dir)
    test_acc_local_model_global_data_dir_path = os.path.join(results_dir, test_acc_local_model_global_data_dir)

    if not os.path.exists(global_test_accuracy_dir_path):
        os.makedirs(global_test_accuracy_dir_path)
    if not os.path.exists(training_loss_dir_path):
        os.makedirs(training_loss_dir_path)
    if not os.path.exists(privacy_spent_dir_path):
        os.makedirs(privacy_spent_dir_path)
    if not os.path.exists(norms_dir_path):
        os.makedirs(norms_dir_path)
    if not os.path.exists(noise_multiplier_dir_path):
        os.makedirs(noise_multiplier_dir_path)
    if not os.path.exists(privacy_spent_per_rnd_dir_path):
        os.makedirs(privacy_spent_per_rnd_dir_path)
    if not os.path.exists(rdp_privacy_spent_per_rnd_dir_path):
        os.makedirs(rdp_privacy_spent_per_rnd_dir_path)
    if not os.path.exists(test_acc_local_model_global_data_dir_path):
        os.makedirs(test_acc_local_model_global_data_dir_path)

    file_test_acc = os.path.join(global_test_accuracy_dir_path,
                                              title + "_" + dataset_name + "_" + "global_test_acc_" +
                                              "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                                  epsilons[2]) + "_"
                                              + "clients_" + str(num_clients) + "_" +
                                              "sigma_" + "{:.2f}".format(sigma) + "_" +
                                              "clip_" + "{:.2f}".format(clip_value) + "_" +
                                              "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                              "runs_" + str(run) + "_" +
                                              "rounds_" + str(num_rounds) + "_" +
                                              "epochs_" + str(num_epochs) + ".txt")

    file_train_loss = os.path.join(training_loss_dir_path,
                                                title + "_" + dataset_name + "_" + "train_loss_" +
                                                "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                                    epsilons[2]) + "_"
                                                + "clients_" + str(num_clients) + "_" +
                                                "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                "runs_" + str(run) + "_" +
                                                "rounds_" + str(num_rounds) + "_" +
                                                "epochs_" + str(num_epochs) + ".txt")

    file_privacy_spent = os.path.join(privacy_spent_dir_path,
                                                title + "_" + dataset_name + "_" + "privacy_spent_" +
                                                "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                                    epsilons[2]) + "_"
                                                + "clients_" + str(num_clients) + "_" +
                                                "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                "runs_" + str(run) + "_" +
                                                "rounds_" + str(num_rounds) + "_" +
                                                "epochs_" + str(num_epochs) + ".txt")

    file_norms = os.path.join(norms_dir_path,
                                                title + "_" + dataset_name + "_" + "norms_" +
                                                "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                                    epsilons[2]) + "_"
                                                + "clients_" + str(num_clients) + "_" +
                                                "sigma_" + "{:.2f}".format(sigma) + "_" +
                                                "clip_" + "{:.2f}".format(clip_value) + "_" +
                                                "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                                "runs_" + str(run) + "_" +
                                                "rounds_" + str(num_rounds) + "_" +
                                                "epochs_" + str(num_epochs) + ".txt")

    file_noise_multiplier = os.path.join(noise_multiplier_dir_path,
                              title + "_" + dataset_name + "_" + "sigma_" +
                              "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                  epsilons[2]) + "_"
                              + "clients_" + str(num_clients) + "_" +
                              "sigma_" + "{:.2f}".format(sigma) + "_" +
                              "clip_" + "{:.2f}".format(clip_value) + "_" +
                              "srate_" + "{:.2f}".format(sample_rate) + "_" +
                              "runs_" + str(run) + "_" +
                              "rounds_" + str(num_rounds) + "_" +
                              "epochs_" + str(num_epochs) + ".txt")

    file_privacy_spent_per_round = os.path.join(privacy_spent_per_rnd_dir_path,
                                         title + "_" + dataset_name + "_" + "privperrnd_" +
                                         "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                             epsilons[2]) + "_"
                                         + "clients_" + str(num_clients) + "_" +
                                         "sigma_" + "{:.2f}".format(sigma) + "_" +
                                         "clip_" + "{:.2f}".format(clip_value) + "_" +
                                         "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                         "runs_" + str(run) + "_" +
                                         "rounds_" + str(num_rounds) + "_" +
                                         "epochs_" + str(num_epochs) + ".txt")

    file_rdp_privacy_spent_per_round = os.path.join(rdp_privacy_spent_per_rnd_dir_path,
                                         title + "_" + dataset_name + "_" + "rdpprivperrnd_" +
                                         "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                             epsilons[2]) + "_"
                                         + "clients_" + str(num_clients) + "_" +
                                         "sigma_" + "{:.2f}".format(sigma) + "_" +
                                         "clip_" + "{:.2f}".format(clip_value) + "_" +
                                         "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                         "runs_" + str(run) + "_" +
                                         "rounds_" + str(num_rounds) + "_" +
                                         "epochs_" + str(num_epochs) + ".txt")

    file_test_acc_local_model_global_data = os.path.join(test_acc_local_model_global_data_dir_path,
                                         title + "_" + dataset_name + "_" + "test_acc_lmgd_" +
                                         "epsilons_" + str(epsilons[0]) + "_" + str(epsilons[1]) + "_" + str(
                                             epsilons[2]) + "_"
                                         + "clients_" + str(num_clients) + "_" +
                                         "sigma_" + "{:.2f}".format(sigma) + "_" +
                                         "clip_" + "{:.2f}".format(clip_value) + "_" +
                                         "srate_" + "{:.2f}".format(sample_rate) + "_" +
                                         "runs_" + str(run) + "_" +
                                         "rounds_" + str(num_rounds) + "_" +
                                         "epochs_" + str(num_epochs) + ".txt")

    with open(file_test_acc, "a") as f:
        global_test_acc_str = ", ".join(map(str, test_acc))
        f.write(f"{global_test_acc_str}\n")

    with open(file_train_loss, "a") as f:
        train_loss_str = ", ".join(map(str, clients_train_loss))
        f.write(f"{train_loss_str}\n")

    with open(file_privacy_spent, "a") as f:
        privacy_spent_str = ", ".join(map(str, clients_privacy_spent))
        f.write(f"{privacy_spent_str}\n")

    with open(file_norms, "a") as f:
        norms_str = ", ".join(map(str, clients_norm))
        f.write(f"{norms_str}\n")

    with open(file_noise_multiplier, "a") as f:
        sigma_str = ", ".join(map(str, clients_per_round_noise_multiplier))
        f.write(f"{sigma_str}\n")

    with open(file_privacy_spent_per_round, "a") as f:
        priv_spent_per_round_str = ", ".join(map(str, clients_per_round_privacy_spent))
        f.write(f"{priv_spent_per_round_str}\n")

    with open(file_rdp_privacy_spent_per_round, "a") as f:
        rdp_priv_spent_per_round_str = ", ".join(map(str, clients_per_round_rdp_privacy_spent))
        f.write(f"{rdp_priv_spent_per_round_str}\n")

    with open(file_test_acc_local_model_global_data, "a") as f:
        file_test_acc_lmgd_str = ", ".join(map(str, clients_test_acc_local_model_global_data))
        f.write(f"{file_test_acc_lmgd_str}\n")

        