#!/bin/bash

# Exit immediately if a command exits with a non-zero status
set -e

# Run experiments in order
echo "Running exact regression experiment..."
python3 experiment_exact.py

echo "Running synthetic regression experiment..."
python3 experiment_synthetic_regression.py

echo "Running superconductivity experiment..."
python3 experiment_superconductivity.py

echo "Running synthetic classification experiment..."
python3 experiment_synthetic_classification.py

echo "Running mnist experiment..."
python3 experiment_mnist.py

echo "All experiments completed successfully."
