import pygame
import random
import time
import json
import os
import argparse
from pygame_screen_record import ScreenRecorder
import os
import json
import random


OBJECTS = ["Red rect", "Red circle", "Green rect", "Green circle", "Yellow circle"]
DIRECTIONS_HORIZONTAL = ["left", "right"]
DIRECTIONS_VERTICAL = ["up", "down"]
id=int(time.time())
def load_json(file_path):
    """Load a JSON file and return its content."""
    with open(file_path, 'r') as f:
        return json.load(f)

def generate_choices_for_question(question, answer):
    """Generate clear and logical choices for different types of questions."""
    if "faster" in question or "slower" in question:

        incorrect_objects = [obj for obj in OBJECTS if obj != answer]
        random_objects = random.sample(incorrect_objects, 3)
        choices = random_objects + [answer]
        random.shuffle(choices)
        choices = [f"{chr(65 + i)}. {choice}" for i, choice in enumerate(choices)]
    elif "How many times" in question or "How many objects" in question:

        answer = int(answer)  
        choices = [
            f"A. {answer - 1 if answer > 0 else 0}",
            f"B. {answer}",
            f"C. {answer + 1}",
            f"D. {answer + 2}"
        ]
    elif "left or right" in question.lower():

        choices = [f"A. left", f"B. right"]
    elif "up or down" in question.lower():

        choices = [f"A. up", f"B. down"]
    elif "fastest-moving" in question.lower() or "slowest-moving" in question.lower():

        incorrect_objects = [obj for obj in OBJECTS if obj != answer]
        random_objects = random.sample(incorrect_objects, 3)
        choices = random_objects + [answer]
        random.shuffle(choices)
        choices = [f"{chr(65 + i)}. {choice}" for i, choice in enumerate(choices)]
    elif "Yes" in answer or "No" in answer:

        choices = ["A. Yes", "B. No"]
    else:

        choices = [f"A. {answer}", "B. Option 1", "C. Option 2", "D. Option 3"]


    correct_answer = next((choice for choice in choices if str(answer) in choice), None)

    return choices, correct_answer



# Initialize Pygame
pygame.init()

# Define colors
RED = (255, 0, 0)
GREEN = (0, 255, 0)
BLUE = (0, 0, 255)
YELLOW = (255, 255, 0)
CYAN = (0, 255, 255)
MAGENTA = (255, 0, 255)

# Define shapes
SHAPES = ["circle", "rect"]
ACTIONS = ["bounce"]

# Additional color choices
COLORS = [RED, GREEN, BLUE, YELLOW, CYAN, MAGENTA]

# Helper function to get the readable color name
def get_color_name(color_value):
    color_map = {RED: "Red", GREEN: "Green", BLUE: "Blue", YELLOW: "Yellow", CYAN: "Cyan", MAGENTA: "Magenta"}
    return color_map.get(color_value, "Unknown Color")

# Generate random objects
def create_random_objects(num_objects):
    objects = []
    used_combinations = set()  # Track used color and shape combinations
    while len(objects) < num_objects:
        shape = random.choice(SHAPES)
        color = random.choice(COLORS)
        combination = (shape, color)
        if combination not in used_combinations:
            used_combinations.add(combination)
            pos = [random.randint(50, 750), random.randint(50, 550)]
            speed_x = random.choice([1,  5, 9]) * random.choice([-1, 1])  # Random speed and direction
            speed_y = random.choice([1,  5,  9]) * random.choice([-1, 1])
            obj = {
                "color": color,
                "shape": shape,
                "pos": pos,
                "speed": [speed_x, speed_y],
                "action": "bounce",
                "wall_bounce_count": 0,
                "initial_direction": [speed_x, speed_y]  # Initial movement direction
            }
            objects.append(obj)
    return objects

# Update object position and handle collisions with walls
def update_object(obj):
    obj["pos"][0] += obj["speed"][0]
    obj["pos"][1] += obj["speed"][1]
    # Check for wall collisions
    if obj["pos"][0] <= 0 or obj["pos"][0] >= 750:
        obj["speed"][0] = -obj["speed"][0]
        obj["wall_bounce_count"] += 1
    if obj["pos"][1] <= 0 or obj["pos"][1] >= 550:
        obj["speed"][1] = -obj["speed"][1]
        obj["wall_bounce_count"] += 1

# Draw object on the screen
def draw_object(screen, obj):
    if obj["shape"] == "circle":
        pygame.draw.circle(screen, obj["color"], obj["pos"], 20)
    elif obj["shape"] == "rect":
        pygame.draw.rect(screen, obj["color"], (*obj["pos"], 50, 50))

# Generate questions based on object behaviors
def generate_questions(objects, n_q):
    qa_pairs = []

    # Helper function to get the readable color name
    def get_color_name(color_value):
        color_map = {RED: "Red", GREEN: "Green", BLUE: "Blue", YELLOW: "Yellow", CYAN: "Cyan", MAGENTA: "Magenta"}
        return color_map.get(color_value, "Unknown Color")

    # Generating multiple questions about which object moves faster
    for _ in range(n_q):
        obj1, obj2 = random.sample(objects, 2)
        color_name1 = get_color_name(obj1["color"])
        color_name2 = get_color_name(obj2["color"])
        shape1 = obj1["shape"]
        shape2 = obj2["shape"]
        speed_obj1 = (obj1["speed"][0] ** 2 + obj1["speed"][1] ** 2)
        speed_obj2 =  (obj2["speed"][0] ** 2 + obj2["speed"][1] ** 2)
        question = f"Which object moves faster: the {color_name1} {shape1} or the {color_name2} {shape2}?"
        if speed_obj1 > speed_obj2:
            answer = f"{color_name1} {shape1}"
        elif speed_obj1 < speed_obj2:
            answer = f"{color_name2} {shape2}"
        else:
            answer = "Both objects move at the same speed"
        qa_pairs.append({"question": question, "answer": answer})
        question = f"Which object moves slower: the {color_name1} {shape1} or the {color_name2} {shape2}?"
        if speed_obj1 > speed_obj2:
            answer = f"{color_name2} {shape2}"
        elif speed_obj1 < speed_obj2:
            answer = f"{color_name1} {shape1}"
        else:
            answer = "Both objects move at the same speed"
        qa_pairs.append({"question": question, "answer": answer})
    # Questions about direction changes after hitting a wall
    for obj in random.sample(objects,min(n_q,len(objects))):
        color_name = get_color_name(obj["color"])
        shape = obj["shape"]
        wall_bounces = obj["wall_bounce_count"]
        question = f"Does the {color_name} {shape} ever change its direction after hitting a wall?"
        answer = f"Yes" if wall_bounces > 0 else "No"
        qa_pairs.append({"question": question, "answer": answer})

        question = f"How many times does the {color_name} {shape} change its direction after hitting a wall?"
        answer = str(wall_bounces) if wall_bounces > 0 else "0"
        qa_pairs.append({"question": question, "answer": answer})

    # Questions about the direction of movement before the first wall collision
    for obj in random.sample(objects,min(n_q,len(objects))):
        color_name = get_color_name(obj["color"])
        shape = obj["shape"]
        # Assuming the initial direction is stored in object properties
        initial_horizontal_direction = "left" if obj["initial_direction"][0] < 0 else "right"
        initial_vertical_direction = "down" if obj["initial_direction"][1] > 0 else "up"
        question_horizontal = f"Is the {color_name} {shape} moving left or right before it first hit a wall?"
        answer_horizontal = initial_horizontal_direction
        qa_pairs.append({"question": question_horizontal, "answer": answer_horizontal})

        question_vertical = f"Is the {color_name} {shape} moving up or down before it first hit a wall?"
        answer_vertical = initial_vertical_direction
        qa_pairs.append({"question": question_vertical, "answer": answer_vertical})
        
    # Determine a random threshold n based on object bounce counts
    bounce_counts = [obj["wall_bounce_count"] for obj in objects]
    n = random.choice(bounce_counts) if bounce_counts else 0

    # Question: Is there any object that has collided with walls more than n times?
    for i in range(n_q):
        n = random.choice(bounce_counts) if bounce_counts else 0
        high_bounce_objects = [obj for obj in objects if obj["wall_bounce_count"] > n]
        if high_bounce_objects:
            question = f"Is there any object that has collided with walls more than {n} times?"
            answer = "Yes"
        else:
            question = f"Is there any object that has collided with walls more than {n} times?"
            answer = "No"
        qa_pairs.append({"question": question, "answer": answer})

    # Question: How many objects have collided with walls more than n times?
    for i in range(n_q):
        n = random.choice(bounce_counts) if bounce_counts else 0
        high_bounce_objects = [obj for obj in objects if obj["wall_bounce_count"] > n]
        question = f"How many objects have collided with walls more than {n} times?"
        count_high_bounce_objects = len(high_bounce_objects)
        answer = str(count_high_bounce_objects)
        qa_pairs.append({"question": question, "answer": answer})
    for i in range(n_q):
        n = random.choice(bounce_counts) if bounce_counts else 0
        high_bounce_objects = [obj for obj in objects if obj["wall_bounce_count"] > n]
    # Question: Does any object have wall bounce count exceeding n times?
        if high_bounce_objects:
            question = f"Does any object have wall bounce count exceeding {n} times?"
            answer = "Yes"
        else:
            question = f"Does any object have wall bounce count exceeding {n} times?"
            answer = "No"
        qa_pairs.append({"question": question, "answer": answer})

    # Question: What is the fastest-moving object?
    fastest_object = max(objects, key=lambda obj: obj["speed"][0]**2+obj["speed"][1]**2, default=None)
    if fastest_object:
        color_name = get_color_name(fastest_object["color"])
        shape = fastest_object["shape"]
        question = "What is the fastest-moving object?"
        answer = f"The {color_name} {shape}"
    else:
        question = "What is the fastest-moving object?"
        answer = "There are no objects."
    qa_pairs.append({"question": question, "answer": answer})
    return qa_pairs
            # obj = {
            #     "color": color,
            #     "shape": shape,
            #     "pos": pos,
            #     "speed": [speed_x, speed_y],
            #     "action": "bounce",
            #     "wall_bounce_count": 0,
            #     "initial_direction": [speed_x, speed_y]  # Initial movement direction
            # }
#     RED = (255, 0, 0)
# GREEN = (0, 255, 0)
# BLUE = (0, 0, 255)
# YELLOW = (255, 255, 0)
# CYAN = (0, 255, 255)
# MAGENTA = (255, 0, 255)
def get_objects_info(objects):
    objects_info = []
    for obj in objects:
        color_name = "Red" if obj["color"] == RED else "Green" if obj["color"] == GREEN else "Blue" if obj["color"] == BLUE else "Yellow" if obj["color"] == YELLOW else "Cyan" if obj["color"] == CYAN else "Magenta"
        object_info = {
            "shape": obj["shape"],
            "color": color_name,
            "action": obj["action"],
            "speed": obj["speed"],
            "wall_bounce_count": obj["wall_bounce_count"]
        }
        objects_info.append(object_info)
    return objects_info

if __name__ == "__main__":
    # Argument parsing
    parser = argparse.ArgumentParser(description="Generate questions and record a Pygame simulation.")
    parser.add_argument("--no", type=int, default=10, help="Number of objects to display.")
    parser.add_argument("--n_q", type=int, default=5, help="Number of questions to generate.")
    parser.add_argument("--output_dir", type=str, default="output", help="Directory to save the output files.")
    parser.add_argument("--t", type=int, default=10, help="t seconds")
    args = parser.parse_args()

    # Set up output directory
    if not os.path.exists(args.output_dir):
        os.makedirs(args.output_dir)

    # Set screen size
    screen = pygame.display.set_mode((800, 600))
    clock = pygame.time.Clock()

    # Generate objects
    objects = create_random_objects(args.no)

    # Start recording
    recorder = ScreenRecorder(120)
    video_file_name = os.path.join(args.output_dir, f"qa_{id}.mp4")
    recorder.start_rec()

    # Main loop
    t = args.t  # Time duration for simulation
    start_time = pygame.time.get_ticks()
    running = True
    while running:
        if pygame.time.get_ticks() - start_time > t * 1000:
            running = False
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                running = False
        screen.fill((225, 225, 225))
        for obj in objects:
            update_object(obj)
            draw_object(screen, obj)
        pygame.display.flip()
        clock.tick(60)

    # Stop recording
    recorder.stop_rec()
    recorder.save_recording(video_file_name)

    pygame.quit()




    # Generate questions and save to JSON
    qa_file_name = os.path.join(args.output_dir, f"qa_{id}.json")
    qa_pairs = generate_questions(objects, args.n_q)
    for qp in qa_pairs:
        qp['choices'],qp['answer']=generate_choices_for_question(qp['question'],qp['answer'])
    objects_info = get_objects_info(objects)

    with open(qa_file_name, 'w') as f:
        json.dump({"questions_answers": qa_pairs, "objects_info": objects_info}, f, indent=4)

