import random
import pygame
import time
from datetime import datetime, timedelta
from pygame_screen_record import ScreenRecorder
import json
import os
import argparse





def generate_shape_choices(answer):
   
    SHAPES = ["circle", "triangle", "square", "rect"]
    """Generate choices for shape questions."""
    correct_answer = answer.strip(" .").lower() 
    incorrect_shapes = [shape for shape in SHAPES if shape != correct_answer]
    choices = random.sample(incorrect_shapes, 3) + [correct_answer]
    random.shuffle(choices)
    choices = [f"{chr(65 + i)}. {choice.capitalize()}" for i, choice in enumerate(choices)]
    correct_answer = next((choice for choice in choices if correct_answer in choice.lower()), None)
    return choices, correct_answer

def generate_color_choices(answer):
    """Generate choices for color questions."""
    COLORS = ["red", "blue", "green", "yellow"]
    correct_answer = answer.strip(" .").lower()  
    incorrect_colors = [color for color in COLORS if color != correct_answer]
    choices = random.sample(incorrect_colors, 3) + [correct_answer]
    random.shuffle(choices)
    choices = [f"{chr(65 + i)}. {choice.capitalize()}" for i, choice in enumerate(choices)]
    correct_answer = next((choice for choice in choices if correct_answer in choice.lower()), None)
    return choices, correct_answer

def generate_cell_choices(answer):
    CELLS = ["row 1, column 2", "row 2, column 1", "row 1, column 3", "row 2, column 3"]

    """Generate choices for cell location questions."""
    correct_answer = answer.strip(" .").lower() 
    incorrect_cells = [cell for cell in CELLS if cell != correct_answer]
    choices = random.sample(incorrect_cells, 3) + [correct_answer]
    random.shuffle(choices)
    choices = [f"{chr(65 + i)}. {choice}" for i, choice in enumerate(choices)]
    correct_answer = next((choice for choice in choices if correct_answer in choice.lower()), None)
    return choices, correct_answer

def generate_choices_for_question(question, answer):
    """Generate clear and logical choices for different types of questions."""
    if "shape" in question.lower():
        
        choices, correct_answer = generate_shape_choices(answer)
    elif "color" in question.lower():
       
        choices, correct_answer = generate_color_choices(answer)
    elif "cell" in question.lower():
       
        choices, correct_answer = generate_cell_choices(answer)
    else:
       
        choices = [f"A. {answer}", "B. Option 1", "C. Option 2", "D. Option 3"]
        correct_answer = choices[0]

    return choices, correct_answer



# Initialize Pygame
pygame.init()

# Screen settings
screen_width, screen_height = 800, 600
screen = pygame.display.set_mode((screen_width, screen_height))
clock = pygame.time.Clock()

# Font settings
font = pygame.font.Font(None, 36)

# Define colors
WHITE = (255, 255, 255)
RED = (255, 0, 0)
GREEN = (0, 255, 0)
BLUE = (0, 0, 255)
BLACK = (0, 0, 0)
def parse_arguments():
    parser = argparse.ArgumentParser(description="Pygame Scene Generator with Screen Recording")
    parser.add_argument('--ts', type=int, default=20, help='Total run time of the video in seconds')
    parser.add_argument('--m', type=int, default=5, help='Number of rows in the grid')
    parser.add_argument('--n', type=int, default=5, help='Number of columns in the grid')
    parser.add_argument('--n_q', type=int, default=5, help='Number of questions to generate')
    parser.add_argument('--output_dir', type=str, default="output/angle1", help='Directory to save output files')
    return parser.parse_args()

COLOR_MAP = {
        (255, 0, 0): "Red",
        (0, 255, 0): "Green",
        (0, 0, 255): "Blue"
    }

# Generate question and answer
def generate_question(first_object_info):
    if not first_object_info:
        return {"question": "No objects appeared in the video.", "answer": "N/A"}
    qa_pair = []
    grid_pos = first_object_info["grid_pos"]
    object_info = first_object_info["object"]
    cell_description = f"row {grid_pos[1] + 1}, column {grid_pos[0] + 1}"
    color_name = COLOR_MAP[tuple(object_info['color'])]
    shape = object_info['shape']

    # question = "In which cell does the first object appear?"
    # answer = f"The first object, a {color_name} {shape}, appeared in cell at {cell_description}."
    # # what the first object shape
    # #what the first obejct color
    # #what the first object appear in which cell
    question="what the first object shape"
    answer = f" {shape}."
    qa_pair.append({"question": question, "answer": answer})
    question="what the first object color"
    answer = f" {color_name}."
    qa_pair.append({"question": question, "answer": answer})
    question="what the first object appear in which cell"
    answer = f" {cell_description}."
    qa_pair.append({"question": question, "answer": answer})
    return qa_pair


# ts=args.ts, n_q=args.n_q, m=args.m, n=args.n, output_dir=args.output_dir
def main(args):
    # Generate unique ID
    id = str(int(time.time()))+'_D'

    # File saving paths
    output_dir = args.output_dir
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)
    file_name = output_dir + f"angle1_{id}.mp4"
    qa_file_name = output_dir + f"angle1_{id}_qa.json"

    # Define shapes
    SHAPES = ["circle", "rect", "triangle"]

    # Define grid size
    n, m = args.n, args.m  # n rows, m columns
    cell_width = screen_width // m
    cell_height = screen_height // n
    t_total = args.ts
    # Color map for object names


    # Create fixed objects for each cell (hidden initially)
    fixed_objects = []
    for i in range(n):
        row = []
        for j in range(m):
            shape = random.choice(SHAPES)
            color = random.choice([RED, GREEN, BLUE])
            pos = [(j * cell_width) + cell_width // 2, (i * cell_height) + cell_height // 2]  # Center position

            if shape == "circle":
                obj = {"shape": "circle", "color": color, "pos": pos, "radius": min(cell_width, cell_height) // 4}
            elif shape == "rect":
                obj = {"shape": "rect", "color": color, "pos": pos, "width": cell_width // 2, "height": cell_height // 2}
            elif shape == "triangle":
                obj = {"shape": "triangle", "color": color, "pos": pos, "size": min(cell_width, cell_height) // 4, "angle": 0}
            obj["visible"] = False  # Initially hidden
            row.append(obj)
        fixed_objects.append(row)

    # Draw grid lines
    def draw_grid(screen):
        for i in range(n + 1):
            pygame.draw.line(screen, (0,0,0), (0, i * cell_height), (screen_width, i * cell_height))
        for j in range(m + 1):
            pygame.draw.line(screen, (0,0,0), (j * cell_width, 0), (j * cell_width, screen_height))

    # Draw objects
    def draw_object(screen, obj):
        if obj["shape"] == "circle":
            pygame.draw.circle(screen, obj["color"], obj["pos"], obj["radius"])
        elif obj["shape"] == "rect":
            rect = pygame.Rect(obj["pos"][0] - obj["width"] // 2, obj["pos"][1] - obj["height"] // 2, obj["width"], obj["height"])
            pygame.draw.rect(screen, obj["color"], rect)
        elif obj["shape"] == "triangle":
            size = obj["size"]
            points = [
                (obj["pos"][0], obj["pos"][1] - size),
                (obj["pos"][0] - size, obj["pos"][1] + size),
                (obj["pos"][0] + size, obj["pos"][1] + size)
            ]
            pygame.draw.polygon(screen, obj["color"], points)


    # Initialization
    current_cell = None  # Currently displayed cell coordinates
    t = 3  # Generate a new object every t seconds
    last_object_time = time.time()  # Time when the last object was generated

    recorder = ScreenRecorder(60)
    recorder.start_rec()

    # Set the total runtime of the animation (seconds)
    t_total = args.ts  # Total animation runs for 30 seconds
    start_time = time.time()  # Record the animation start time

    # For recording the first object's position
    first_object_info = None

    # List to keep track of displayed objects
    displayed_cells = []

    # Main loop
    running = True
    while running:
        screen.fill(BLACK)  # Clear the screen
        screen.fill((225, 225, 225))
        # Draw grid lines
        draw_grid(screen)

        # Check if the animation has run for more than t_total seconds
        if time.time() - start_time >= t_total:
            running = False  # End animation

        # Check if a new object needs to be displayed
        if time.time() - last_object_time > t:
            # Hide the previous object
            if current_cell is not None:
                fixed_objects[current_cell[1]][current_cell[0]]["visible"] = False

            # Choose a random cell to display its object
            grid_pos = (random.randint(0, m - 1), random.randint(0, n - 1))  # (column, row)
            current_cell = grid_pos
            fixed_objects[current_cell[1]][current_cell[0]]["visible"] = True
            last_object_time = time.time()  # Update the time when the object was generated

            # Record the first object's position
            if not first_object_info:
                first_object_info = {
                    "grid_pos": current_cell,
                    "object": fixed_objects[current_cell[1]][current_cell[0]].copy()
                }

            # Keep track of displayed cells
            displayed_cells.append({
                "grid_pos": current_cell,
                "object": fixed_objects[current_cell[1]][current_cell[0]].copy()
            })

        # Draw only the currently visible object
        for i in range(n):
            for j in range(m):
                obj = fixed_objects[i][j]
                if obj["visible"]:
                    draw_object(screen, obj)

        # Check for events
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                running = False

        pygame.display.flip()
        clock.tick(60)  # 60 frames per second

    # Stop recording and save video
    recorder.stop_rec()  # Stop recording
    recorder.save_recording(file_name)  # Save the recording

    pygame.quit()


    # Generate question and answer
    qa_pairs = generate_question(first_object_info)
    for qa in qa_pairs:
        qa['ans']=qa['answer']
        qa['choices'],qa['answer']=generate_choices_for_question(qa['question'],qa['answer'])
    # Save the results

    output_data = {
        "questions_answers": qa_pairs,
    
    }

    with open(qa_file_name, 'w') as f:
        json.dump(output_data, f, indent=4)
    with open(qa_file_name, 'w') as f:
        json.dump(output_data, f, indent=4)


if __name__ == "__main__":
    args = parse_arguments()
    main(args)
