'''
This program is for generation of RHPs for random search
'''

import numpy as np
import csv

row = 96    # Number of the wells
column = 7  # Number of the features, in this paper it is 7
TotalVolume = 60 # Total volume of the organohalide in each well, in this paper it is 60 μL


# Normalize the elements to the sum of that row 
def normalization (a):
    b = np.sum(a)
    return a/b

# Generate the random matrix of the mole fraction
ranMatrix = np.zeros([row,column])
for i in range(ranMatrix.shape[0]):
    a = np.apply_along_axis(normalization, 0, np.random.rand(column))
    ranMatrix[i, ] = a

# Multiply the mole fraction with the total volume to get the volume for each organohalide
AddMatrix = np.around(ranMatrix * TotalVolume,1)
#first six wells should be zero
for i in range(6+column):
    AddMatrix[i, : ] = 0


# First 13 rows were set to zero for calibration 
n=0
for i in range(6, 6+column):
        AddMatrix[i, n] = 0
        n = n + 1
# Save the Matrix
np.savetxt('RawMatrix-N14P71-P2.csv', AddMatrix,fmt=('%1.1f', '%1.1f', '%1.1f', '%1.1f', '%1.1f', '%1.1f', '%1.1f'),delimiter=',')

# Transfer the Matrix to the Command csv file for Janus workstation
 
janus = open('JanusAddingFile-N14P71-P2.csv','w')
janusCreater = csv.writer(janus)
for r in range(row):
    for c in range(column):
        volume = np.around(AddMatrix[r,c],1)
        imputCSV = ['Source', c+1, 'Dest', r+1, volume]
        janusCreater.writerow(imputCSV)
janus.close()
