import sys
sys.path.append('../')
import warnings
warnings.filterwarnings("ignore")
import numpy as np
from pymoo.core.problem import Problem

class MyProblem(Problem):
    def __init__(self, base):
        self.base = base
        super().__init__(
            n_var=len(self.base.encoder_normalize_data_catalog.feature_names),
            n_obj=2,
            xl=np.array(list(self.base.feature_range_min.values())),
            xu=np.array(list(self.base.feature_range_max.values())),
            )

    def _evaluate(self, cfs, out, *args, **kwargs):
        loss_1 = self.base.compute_yloss(cfs)
        loss_2 = self.base.compute_proximity_loss(cfs, self.base.query_instance)
        out["F"] = np.column_stack([loss_1, loss_2])