#!/bin/bash
#SBATCH -J halu_riddlesense
#SBATCH -c 8
#SBATCH -t 32:00:00
#SBATCH -p gpu_dia
#SBATCH --gres=gpu:1
#SBATCH --mem=200G
#SBATCH -o logs/%x_%j.out
#SBATCH -e logs/%x_%j.err

module purge
module load dgx
module load miniconda3/24.1.2
module load cuda12.1/blas/12.1.1

source activate
conda deactivate
conda activate halu

cd /n/lw_groups/hms/dbmi/yu/lab/jz290/hallucination-agent
/home/jz290/.conda/envs/halu/bin/python run_inference.py \
    --dataset riddlesense \
    --demo_path demos/multiarith \
    --model Meta-Llama-3-8B-Instruct \
    --method zero_shot_cot \
    --model_path /n/lw_groups/hms/dbmi/yu/lab/jz290/hallucination-agent/init_weights/ \
    --data_path /n/lw_groups/hms/dbmi/yu/lab/jz290/hallucination-agent/dataset/ \
    --output_dir /n/lw_groups/hms/dbmi/yu/lab/jz290/hallucination-agent/experiment/riddlesense.pkl