function arf = AccMD(x0, y0, data, max_iters, tol, StopCrit)

% Initialization
f = data.f; grad = data.gradf; dh = data.dh; dh_inv = data.dh_inv;
L = data.L_relative; mu = data.mu_relative; alpha = sqrt(mu/L);
f_true = data.f_true;

x = x0; y = y0; z = dh(y);
g = grad(x); g0 = g; f0 = f(x);
arf = zeros(max_iters+1,1); arf(1) = 1;
elapse = 0;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, g, fx) norm(g) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, g, fx) fx < f0 * tol;
end

for iter = 1:max_iters
    
    tic;
    % Update x, y
    z_new = (z+alpha*dh(x)-alpha*g/mu)/(1+alpha);
    y_new = dh_inv(z_new);
    x_new = alpha/(1+alpha) * (2*y_new - y) + x/(1+alpha);
    
    % Update x, y, and z
    x = x_new; y = y_new; z = z_new; g = grad(x); 
    elapse = elapse + toc;    
    fx = f(x); arf(iter+1) = (fx-f_true)/(f0-f_true);
    if ismember(iter,[10,20,50,100,150,200])
        fprintf('Iter %d: function gap = %f, time = %f.\n', iter, arf(iter+1), elapse)
    end
    % Check for convergence
    if StopFunc(x, y, g, fx)
        fprintf('Acc-MD converges after %d iterations.\n', iter);
        break;
    end

end
t = elapse;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));

end