function arf = AccMDcomposite(x0, y0, data, max_iters, tol, StopCrit)

% Initialization
f = data.f; grad = data.gradf; dh = data.dh; f_true = data.f_true;
L = data.L_relative; mu_min = data.mu_relative; prox_D = data.prox_mir; % alpha = sqrt(mu/L);
mu = data.mu0_relative; mk = data.m0; iter = 0;

x = x0; y = y0; z = dh(y);
g = grad(x); g0 = g;
arf = zeros(max_iters+1,1); arf(1) = 1; f0 = f(x); init_gap = f0-f_true;
exitFlag = false; elapse = 0;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, q, fx) norm(grad(y)-q) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, q, fx) fx < f0 * tol;
end

for outer_iter = 1:100
    alpha = sqrt(mu/L);
    for inner_iter = 1:mk
    % inner iteration
        tic;
        if iter >= max_iters
            break;
        end
        iter = iter + 1; % total # iter so far
        z_intermediate = (z+alpha*dh(x)-alpha*g/mu)/(1+alpha);
        y_new = prox_D(z_intermediate, alpha/((1+alpha)*mu));
        x_new = alpha/(1+alpha) * (2*y_new - y) + x/(1+alpha);
        z_new = dh(y_new);
        q_new = (mu * (1+alpha)/alpha ) * (z_intermediate - z_new);
        x = x_new; y = y_new; z = z_new; g = grad(x); fx = f(x);
        arf(iter+1) = (fx-f_true)/init_gap;
        elapse = elapse + toc;

        % Check for convergence
        if StopFunc(x,y,q_new,fx)
            fprintf('Acc-MD-composite converges after %d iterations.\n', iter);
            exitFlag = true;
            break;
        end
    
    end
    if exitFlag || iter >= max_iters
        break;
    end
    % outer iter: update mu
    if mu >= 2 * mu_min
        mu = mu/2;
        mk = ceil(mk*sqrt(2));
    else
        mu = mu_min;
        mk = Inf;
    end
end

fprintf("Elapsed time = %f.\n",elapse);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end