function arf = AORHBcomposite(x0, y0, data, max_iters, tol, StopCrit)

f = data.f; grad = data.gradf; prox = data.prox; L = data.L;
mu_min = data.mu; f_true = data.f_true;
mu = data.mu0; mk = data.m0; iter = 0;

x = x0; y = y0; f0 = f(x);
g = grad(x); g0 = g;
arf = zeros(max_iters+1,1); arf(1) = 1;
exitFlag = false; elapse = 0;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, q, fx) norm(grad(y)-q) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, q, fx) fx < f0 * tol;
end
for outer_iter = 1:100
% iter over mu
    alpha = sqrt(mu/L);
    for inner_iter = 1:mk
        tic;
        if iter >= max_iters
            break;
        end
        iter = iter + 1;
        x_new = (x + alpha*y)/(1+alpha);
        g_new = grad(x_new);
        y_new = (y + alpha * x_new - alpha/mu*(2*g_new - g))/(1+alpha);
        y_new = prox(y_new, alpha/((1+alpha)*mu));
        q_new = mu * (y_new - y)/alpha - mu * (x_new - y_new) + (2 * g_new - g);
        x = x_new; y = y_new; g = g_new; fx = f(x);
        arf(iter+1) = (fx-f_true)/(f0-f_true);
        elapse = elapse + toc;
        if StopFunc(x,y,q_new,fx)
            fprintf('AOR-HB converges after %d iterations.\n', iter);
            exitFlag = true;
            break;
        end
    end
    if exitFlag || iter >= max_iters
        break;
    end
    % outer iter: update mu
    if mu >= 2 * mu_min
        mu = mu/2;
        mk = ceil(mk*sqrt(2));
    else
        mu = mu_min;
        mk = 1e6;
    end
end

fprintf("Elapsed time = %f.\n",elapse);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end