function arf = BPG(x0, ~, data, max_iters, tol, StopCrit)

% Initialization
f = data.f; grad = data.gradf; prox_D = data.prox_mir; dh = data.dh;
L = data.L_relative; f_true = data.f_true;

x = x0; z = dh(x);
g = grad(x); g0 = g;
arf = zeros(max_iters+1,1); arf(1) = 1; f0 = f(x);
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, g, fx) norm(g) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, g, fx) fx < f0 * tol;
end

% Gradient Descent Loop
tic;
for iter = 1:max_iters
    
    % fprintf('Iter %d, f(x)=%f.\n', iter, f(x));
    % Update x
    z_intermediate = z - g/L;
    x_new = prox_D(z_intermediate, 1/L);
    z_new = dh(x_new);
    q_new = L * (z_intermediate - z_new);
        
    % Update x, y, and z
    x = x_new; z = z_new; g = grad(x); fx = f(x);
    arf(iter+1) = (fx-f_true)/(f0-f_true);

    % Check for convergence
    if StopFunc(x,x,g+q_new,fx)
        fprintf('BPG converges after %d iterations.\n', iter);
        break;
    end

end
t = toc;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end