function arf = FISTA(x0, ~, data, max_iters, tol, StopCrit)
% Nestorov's Fast Iterative Shrinkage-Thresholding Algorithm (FISTA)

grad = data.gradf; prox = data.prox; f = data.f; L = data.L;
grad = @(x) grad(x); f_true = data.f_true;

% intialization
x = x0; y = x; t = 1;
f0 = f(x); g = grad(y); g0 = g;
arf = zeros(max_iters+1,1); arf(1) = 1;
elapse = 0;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, comp_grad, fx) norm(comp_grad) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, comp_grad, fx) fx < f0 * tol;
end

for iter = 1:max_iters
    tic;
    z = y - g/L;
    x_new = prox(z, 1/L);
    t_new = 0.5*(1+sqrt(1+4*t^2));
    y_new = x_new + ((t-1)/t_new)*(x_new-x);
    g_new = grad(y_new); fx = f(x_new);
    elapse = elapse + toc;
    comp_grad_x = norm(grad(x_new)+L*(z-x_new));
    if StopFunc(x_new,y_new,comp_grad_x,fx)
        fprintf('FISTA converged after %d iterations.\n', iter);
        break;
    end
    x = x_new; y = y_new; t = t_new; g= g_new;
    arf(iter+1) = (fx-f_true)/(f0-f_true);
end

% outputs
fprintf("Elapsed time = %f.\n",elapse);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end