function arf = ABPG_gamma2(x0, ~, data, max_iters, tol, StopCrit)
% An implementation of Hanzely et al, in the special case \gamma = 2.

% obtain data
f = data.f; dh = data.dh; dh_inv = data.dh_inv; grad = data.gradf; L = data.L_relative;
f_true = data.f_true;

% set parameters
x = x0; z = x0; theta = 1; z_dual = dh(z); f0 = f(x);
g = grad(z); g0 = g;
arf = zeros(max_iters+1,1); arf(1) = 1;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, comp_grad, fx) norm(comp_grad) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, comp_grad, fx) fx < f0 * tol;
end
elapse = 0;

for iter = 1:max_iters-1
    tic;
    y = (1-theta) * x + theta * z;
    g = grad(y);
    z_dual_new = z_dual-g/(L*theta);
    z_new = dh_inv(z_dual_new);
    % comp_grad_z = grad(z_new) - ( grad(y)+theta*L*(z_dual_new-z_dual) );
    x_new = (1-theta) * x + theta * z_new;
    theta = 2 * theta / (theta+sqrt(theta^2+4));
    x = x_new; z = z_new; z_dual = z_dual_new; fx = f(x);
    arf(iter+1) = (fx-f_true)/(f0-f_true);
    % if norm(comp_grad_z,"fro")/norm(g0,"fro") < tol
    elapse = elapse + toc;
    if ismember(iter,[10,20,50,100,150,200])
        fprintf('Iter %d: function gap = %f, time = %f.\n', iter, arf(iter+1), elapse)
    end
    if StopFunc(x,y,g,fx)
        fprintf('Converged after %d iterations.\n', iter);
        break;
    end
end
 

% outputs
t = elapse;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end