function arf = MD(x0, ~, data, max_iters, tol, StopCrit)

% Initialization
f = data.f; grad = data.gradf; dh = data.dh; dh_inv = data.dh_inv;
L = data.L_relative; f_true = data.f_true;

x = x0; z = dh(x);
g = grad(x); g0 = g; f0 = f(x);
arf = zeros(max_iters+1,1); arf(1) = 1;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, g, fx) norm(g) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, g, fx) fx < f0 * tol;
end
elapse = 0;

% Gradient Descent Loop

for iter = 1:max_iters
    
    tic;
    % fprintf('Iter %d, f(x)=%f.\n', iter, f(x));
    % Update x
    z_new = z - g/L;
    x_new = dh_inv(z_new);
        
    % Update x, y, and z
    x = x_new; z = z_new; g = grad(x); fx = f(x);
    arf(iter+1) = (fx-f_true)/(f0-f_true);
    elapse = elapse+toc;
    if ismember(iter,[10,20,50,100,150,200])
        fprintf('Iter %d: function gap = %f, time = %f.\n', iter, arf(iter+1), elapse)
    end
    % Check for convergence
    if StopFunc(x, x, g, fx)
        fprintf('MD converges after %d iterations.\n', iter);
        break;
    end

end
t = elapse;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end