function arf = NAG(x0, ~, data,max_iters,tol,StopCrit)
% An implementation of Nestorov's method,
% x_{k+1} = x_k - h f'(y_k)
% y_{k+1} = x_{k+1} + \beta (x_{k+1}-x_k)
% where h = 1/L, and \beta = k/(k+3).

% obtain data
f = data.f; grad = data.gradf; L = data.L; f_true = data.f_true;

% intialization
x = x0; y = x0; g = grad(y); g0 = g; f0 = f(x);
arf = zeros(max_iters+1,1); arf(1,:) =1;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, g, fx) norm(g) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, g, fx) fx < f0 * tol;
end

tic;
% assign parameters, all parameters fixed.
Lk = L; alpha = 1/Lk;
for iter = 1:max_iters
    beta = (iter - 1)/(iter + 2);
    x_new = y - alpha * g;
    y_new = x_new + beta * (x_new - x);
    x = x_new; y = y_new; fx = f(x); g = grad(y);
    arf(iter+1) = (fx-f_true)/(f0-f_true);
    if StopFunc(x, y, g, fx)
        fprintf('NAG converges after %d iterations.\n', iter);
        break;
    end
end
 

% outputs
t = toc;
fprintf("Elapsed time = %f.",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end