function arf = NAMD(x0, ~, data, max_iters, tol, StopCrit)

% obtain data
f = data.f; grad = data.gradf; L = data.L; dh_inv = data.dh_inv; 
f_true = data.f_true;
sigma = 1; % strong convexity constant of \phi

% set parameters
x = x0; g = grad(x); g0 = g; f0 = f(x);
arf = zeros(max_iters+1,1); arf(1) = 1;
s = 1/L; % step size
grad_par_sum = 0.5 * g; % partial sum of gradients used in update of Nestorov's AMD
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, g, fx) norm(g) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, g, fx) fx < f0 * tol;
end

tic;
for iter = 1:max_iters-1
    y = x - s * g;
    z = dh_inv(-sigma*s*grad_par_sum);
    k = iter - 1; x_new = (2*z + (k+1)*y)/(k+3);
    x = x_new; fx = f(x); 
    g = grad(x); grad_par_sum = grad_par_sum + 0.5 * (iter + 1) * g;
    arf(iter+1) = (fx-f_true)/(f0-f_true);
    if StopFunc(x, y, g, fx)
        fprintf('NAMD converges after %d iterations.\n', iter);
        break;
    end
end
 

% outputs
t = toc;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
end