function [varargout] = reference_optimizer_mir(x0, ~, data, max_iters, tol, StopCrit)
% An implementation of Hanzely et al, in the special case \gamma = 1.

% obtain data
f = data.f; dh = data.dh; grad = data.gradf; L = data.L_relative;
dh_inv = data.dh_inv;

% set parameters
x = x0; z = x0; theta = 1; z_dual = dh(z); f0 = f(x);
g = grad(z); g0 = g;
arf = zeros(max_iters+1,1); arf(1) = 1;
if strcmp(StopCrit, 'GradNorm')
    StopFunc = @(x, y, comp_grad, fx) norm(comp_grad) < tol * norm(g0);
elseif strcmp(StopCrit, 'FuncVal')
    StopFunc = @(x, y, comp_grad, fx) fx < f0 * tol;
end

tic;
for iter = 1:max_iters-1
    y = (1-theta) * x + theta * z;
    g = grad(y);
    z_dual_new = z_dual-g/L;
    z_new = dh_inv(z_dual_new);
    x_new = (1-theta) * x + theta * z_new;
    theta = theta/(1+theta);
    x = x_new; z = z_new; z_dual = z_dual_new; fx = f(x);
    if StopFunc(x,y,g,fx)
        fprintf('Converged after %d iterations.\n', iter);
        break;
    end
end
 

% outputs
t = toc;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
varargout{1} = arf(1:iter+1);
if nargout >= 2
    varargout{2} = x_new;
end