function func = data_lasso(n,d)
% f = h + g
% h = 0.5 * x' * A * x , unnormalized
% g = \lambda * norm(x,1)

    function x_prox = soft_thresholding(z, alpha)
        % Soft-thresholding (Proximal operator for L1 norm)
        x_prox = sign(z) .* max(abs(z) - lambda * alpha, 0);
    end

    function x_prox = soft_thresholding_D(z, alpha)
        % Soft-thresholding (Proximal operator for L1 norm)
        % D = diag(d_i)
        z = dh_inv(z);
        x_prox = sign(z) .* max(abs(z) - lambda * alpha ./diagA, 0);
    end


% k = floor(d/40);
k =50;
sigma = 1;
rng(42);
X = randn(n,d);
scale = linspace(1,d,d);
X = X .* scale;
idx = randperm(d, k); % Random indices for nonzero elements
values = randn(k, 1); % Random nonzero values
x_true = sparse(idx, ones(k,1), values+sign(values), d, 1);
noise = sigma * randn(n,1);
b = X * x_true + noise;

A = X'*X;
L = max(eig(A));
mu = 0;
lambda = 1;

diagA = diag(A); D_half = diag(diagA.^(-1/2));
L_relative = max(eig(D_half*A*D_half));
mu_relative = 0;

clear A D_half;

func = struct('n',n,'d',d,'F',@F,'f',@f,'gradf',@grad,'prox',@soft_thresholding,'prox_mir',@soft_thresholding_D, ...
    'G',@G,'x_true',x_true, 'f_true',f(x_true), 'mu0_relative', L_relative/100, 'mu0', L/100, 'm0', 100, ...
    'L',L,'mu',mu,'L_relative',L_relative,'mu_relative',mu_relative, 'h', @h, 'dh', @dh, 'dh_inv', @dh_inv);

function y = f(x)
    y = 0.5*norm(X*x-b)^2;
end

function v = grad(x) 
    v = X'*(X * x - b);
end

function z = G(x)
    z = lambda * norm(x,1);
end

function y = F(x)
    y = f(x) + G(x);
end

function y = h(x)
% reference function evaluation
    y = 0.5 * sum(diagA .* (x.^2));
end

function v = dh(x)
% gradient of the reference function
    v = diagA .* x;
end

function v = dh_inv(x)
% inverse of mirror map
    v = (1 ./ diagA) .* x;
end

end