function func = data_loglinear(n)
% log-linear loss function
% entropic mirror descent


%%
rng(2);
g = randn(n,1);
C = 0.01;
L_relative = 1 + max(g.^2)/C;
mu_relative = 1;

clear A0;

func = struct('n',n,'f',@f,'h',@h,'gradf',@grad,'dh',@dh,'dh_inv',@dh_inv,...
'L_relative', L_relative, 'mu_relative', mu_relative, ...
   'mu0_relative', L_relative/100, 'm0', 9);

function v = grad(x)
    v = log(x)+1 + g*(g'*x)/C;
end

function y = f(x)
    y = sum(x.*log(x)) + 0.5 * (g'*x)^2/C;
end

function y = h(x)
    y = sum(x.*log(x));
end

function v = dh(x)
    v = log(x)+1;
end

function v = dh_inv(x)
    v = exp(x) ./ (sum(exp(x)));
end

end