function func = data_quartic_hard(n)

A = randn(n)/sqrt(n);
b = zeros(n,1);
% b = rand(n,1)/10;
C0 = randn(n); C = eye(n) + C0' * C0/n;
% C = eye(n);
d = rand(n,1) ;
% E = 2*eye(n);
E0 = randn(n); E = 2 * eye(n) + E0' * E0/n;

R = norm(d);
% R = 5;
L = (3*norm(A)^2*norm(b)^2+norm(C)^2)+6*norm(A)^3*norm(b)*R+3*(norm(E)^4+norm(A)^4)*R^2;
L_relative = 3*norm(E)^4 + 3*norm(A)^4 + 6*norm(A)^3*norm(b) + 3*norm(A)^2*norm(b)^2 + norm(C)^2;
sigma_C = eigs(C, 1, 'sm');
sigma_E = eigs(E, 1, 'sm');
mu_relative = min(sigma_E^4/3, sigma_C^2);
mu = sigma_C^2;

func = struct('n',n,'f',@f,'gradf',@grad,'h',@h,'dh',@dh, 'dh_inv', @dh_inv, ...
    'L_relative', L_relative, 'mu_relative', mu_relative, 'L', L, 'mu', mu);

function y = f(x)
    y = 0.25*norm(E*x)^4 + 0.25*norm(A*x-b,4)^4 + 0.5*norm(C*x-d)^2;
end

function v = grad(x)
    v = norm(E*x)^2 * (E' * E) * x + A' * ((A * x - b).^3) + C' * (C * x - d);
end

function y = h(x)
    y = 0.25 * norm(x)^4 + 0.5 * norm(x)^2;
end

function v = dh(x)
    v = (norm(x)^2+1) * x;
end

function x = dh_inv(z)
% inverse dh
    r = roots([1,0,1,-norm(z)]);
    r = r(real(r) > 0 & imag(r) == 0);
    x = z/(r^2+1);
end
end