% This script tests Acc-MD method on the optimization problem:
% log-linear

addpath('baselines/smooth-convex/');
colors = [0 0.2 0.6;  
      0 0 0; 
      0.93 0.69 0.13; 
      0.502, 0.0, 0.502;   
      0.0, 0.392, 0.0]; 
rng(2);

%% log-linear Objective
n = 2048;
data = data_loglinear(n);
% data = data_loglinear_dual_classification(100);
x0 = rand(n,1); y0 = rand(n,1);
x0 = exp(x0)/sum(exp(x0)); y0 = exp(y0)/sum(exp(y0));
max_iters = 10000; tol = 1e-6; StopCrit = 'GradNorm';
[~,solution] = reference_optimizer_mir(x0, y0, data, 100000, 1e-14, StopCrit);
data.x_true = solution; data.f_true = data.f(solution);
figure;
arf = AccMD(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(1,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = ABPG_gamma1(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(2,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = ABPG_gamma2(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(2,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = MD(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(5,:),'LineWidth',0.5,'MarkerSize',2);
hold off;
xlim([1,2000]); ylim([1e-8,1]);
xlabel('Number of Steps','FontName','Times New Roman'); 
ylabel('$(f(x)-f(x^*))/(f(x_0)-f(x^*))$','Interpreter','latex','FontName','Times New Roman');
legend('Acc-MD','ABPG ($\gamma=1$)','ABPG ($\gamma=2$)','BPG','Location','best','FontName','Times New Roman','Interpreter','latex'); grid on; 
